<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Access\PasswordReset\PasswordReset;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class ApiAuthController extends Controller
{
    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|string|email|max:255',
            'password' => 'required|string|min:6',
        ]);
        if ($validator->fails()) {
            return response(['status' => 0, 'errors' => $validator->errors()->all()], 422);
        }
        $user = User::where('email', $request->email)->first();
        if ($user) {
            $id = $user->role->id;

            if (($id == '2') || ($id == '5')) {
                if (Hash::check($request->password, $user->password)) {
                    $token = $user->createToken('Bearer')->accessToken;

                    $response = ['status' => 1, 'token' => $token, 'user' => $user];
                    return response($response, 200);
                } else {
                    $response = ['status' => 0, "message" => "Password mismatch"];
                    return response($response, 422);
                }
            } else {
                $response = ['status' => 0, "message" => "You don't have the rights to access the application. Access Denied!"];
                return response($response, 422);
            }

        } else {
            $response = ['status' => 0, "message" => 'User does not exist'];
            return response($response, 422);
        }
    }


    public function logout(Request $request)
    {
        $token = $request->user()->token();
        $token->revoke();
        $response = ['message' => 'You have been successfully logged out!'];
        return response($response, 200);
    }

    public function forgotPassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|string|email|max:255',
        ]);
        if ($validator->fails()) {
            return response(['status' => 0, 'errors' => $validator->errors()->all()], 422);
        }

        $token = Hash::make('token', [
            'rounds' => 10,
        ]);

        $user = User::where('email', $request->email)->first();
        if ($user) {
            $passreset = PasswordReset::insert([
                'email' => $request->email,
                'token' => $token,
                'created_at' => Carbon::now()
            ]);
            if ($passreset) {
                $response = ['status' => 1, "message" => 'Password reset request created'];
                return response($response, 200);
            } else {
                $response = ['status' => 0, "message" => 'Password reset request failed'];
                return response($response, 500);
            }
        } else {
            $response = ['status' => 0, "message" => 'User does not exist'];
            return response($response, 422);
        }
    }

    public function resetPassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|string|email|max:255',
            'password' => 'required|string|min:6',
        ]);
        if ($validator->fails()) {
            return response(['status' => 0, 'errors' => $validator->errors()->all()], 422);
        }
        $updatePassword = PasswordReset
            ::where([
                'email' => $request->email
            ])
            ->first();
        if (!$updatePassword) {
            return response(['status' => 0, 'errors' => 'Invalid token! Do send a forgot password request'], 422);
        }

        $user = User::where('email', $request->email)
            ->update(['password' => Hash::make($request->password)]);
        if ($user) {
            PasswordReset::where(['email' => $request->email])->delete();
            $response = ['status' => 1, "message" => 'Password reset successful'];
            return response($response, 200);

        } else {
            $response = ['status' => 0, "message" => 'Password reset unsuccessful'];
            return response($response, 500);
        }

    }
}
