<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

namespace App\Http\Controllers\Crm;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\project\ProjectRepository;
use App\Http\Requests\Focus\project\ManageProjectRequest;

/**
 * Class ProjectsTableController.
 */
class ProjectsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var ProjectRepository
     */
    protected $project;

    /**
     * contructor to initialize repository object
     * @param ProjectRepository $project ;
     */
    public function __construct(ProjectRepository $project)
    {
        $this->project = $project;
    }

    /**
     * This method return the data of the model
     * @param ManageProjectRequest $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        //
        $core = $this->project->getSelfDataTable(auth('crm')->user()->id);
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('tid', function($project) {
                return gen4tid('Prj-', $project->tid);
            })
            ->addColumn('customer', function($project) {
                $name = '';
                $customer = $project->customer_project;
                if ($customer) $name = "{$customer->company}";
                return $name;
            })
            ->addColumn('start_date', function ($project) {
                return dateFormat($project->start_date);
            })
            ->addColumn('end_date', function ($project) {
                return dateFormat($project->end_date);
            })
            ->addColumn('qty_needed', function ($project) {
            return NumberFormat($project->qty_needed);
            })
            ->addColumn('delivery_date', function ($project) {
                return dateFormat($project->delivery_date);
            })
            ->addColumn('priority', function ($project) {
                return ucfirst($project->priority);
            })
            ->addColumn('actions', function ($project) {
                // $view = "{{route(biller.projects.show, $project)}}";
                return '<a href="'.route('crm.projects.show', $project).'" title="View"><i  class="ft-eye"></i></a> ';
            })
            ->make(true);
    }
}
