<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

namespace App\Http\Controllers\Focus\account;

use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\account\AccountRepository;
use App\Http\Requests\Focus\account\ManageAccountRequest;

/**
 * Class AccountsTableController.
 */
class CashbookTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var AccountRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param AccountRepository $repository;
     */
    public function __construct(AccountRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * This method return the data of the model
     * @param ManageAccountRequest $request
     *
     * @return mixed
     */
    public function __invoke(ManageAccountRequest $request)
    {
        $query = AccountsController::cashbook_transactions();

        $q = clone $query;
        $tr_totals = $q->selectRaw('SUM(debit) as debit, SUM(credit) as credit, SUM(debit-credit) as balance')->first();

        return Datatables::of($query)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->editColumn('date', function ($tr) {
                return dateFormat($tr->date);
            })
            ->editColumn('note', function ($tr) {
                return $tr->note;
            })
            ->addColumn('type', function ($tr) {
                if ($tr->debit > 0) return 'Cash In';
                return 'Cash Out';
            })
            ->addColumn('tid', function ($tr) {
                $tid = '';
                if ($tr->debit > 0) {
                    $bank_trans = $tr->bank_transfer;
                    if ($bank_trans) $tid .= '<a href="'. route('biller.banktransfers.show', $bank_trans) .'">'. gen4tid('XFER', $bank_trans->tid) .'</a>';
                } else {
                    $payment = $tr->payment;
                    $bank_charge = $tr->bank_charge;
                    if ($payment) $tid .= '<a href="'. route('biller.billpayments.show', $payment) .'">'. gen4tid('PMT-', $payment->tid) .'</a>';
                    if ($bank_charge) $tid .= '<a href="'. route('biller.charges.show', $bank_charge) .'">'. gen4tid('CHR-', $bank_charge->tid) .'</a>';
                }
                return $tid;
            })
            ->editColumn('ledger_id', function ($tr) {
                return @$tr->account->name;
            })
            ->addColumn('debit', function ($tr) {
                if ($tr->debit > 0) return numberFormat($tr->debit);
                return '';
            })
            ->addColumn('credit', function ($tr) {
                if ($tr->credit > 0) return numberFormat($tr->credit);
                return '';
            })
            ->addColumn('totals', function ($tr) use($tr_totals) {
                $tr_totals = $tr_totals->toArray();
                foreach ($tr_totals as $key => $value) {
                    $tr_totals[$key] = numberFormat($value);
                }
                return $tr_totals;
            })
            ->make(true);
    }
}
