<?php

namespace App\Http\Controllers\Focus\assembly\assembled_product;

use App\Http\Controllers\Controller;
use App\Http\Requests\Focus\assembly\assembled_product\CreateAssembledProductRequest;
use App\Http\Requests\Focus\assembly\assembled_product\ManageAssembledProductRequest;
use App\Http\Requests\Focus\assembly\assembled_product\StoreAssembledProductRequest;
use App\Repositories\Focus\assembly\AssembledProductRepository;
use Illuminate\Http\Request;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\assembly\assembled_products\CreateResponse;
use Illuminate\Support\Arr;
use App\Http\Responses\RedirectResponse;
use App\Models\assembly\assembled_product\AssembledProduct;
use App\Http\Responses\Focus\assembly\assembled_products\EditResponse;
use App\Models\product\Product;

class AssembledProductController extends Controller
{
    protected $repository;

    public function __construct(AssembledProductRepository $repository)
    {
        $this->repository = $repository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ManageAssembledProductRequest $request)
    {
        // return 1;
        return new ViewResponse('focus.assembly.assembled_product.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(CreateAssembledProductRequest $request)
    {
        return new CreateResponse('focus.assembly.assembled_product.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreAssembledProductRequest $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['user_id'] = auth()->user()->id;

        try {
            $this->repository->create($input);
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler('Error Creating Product', $th);
        }

        return new RedirectResponse(route('biller.assembled-products.index'), ['flash_success' => 'Assembled products were added successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $assembled_products = AssembledProduct::where('id', $id)->with('assembled_product_items')->first();
        return new ViewResponse('focus.assembly.assembled_product.view', compact('assembled_products'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(ManageAssembledProductRequest $request ,$id)
    {
        $assembled_product = AssembledProduct::where('id', $id)->with('assembled_product_items')->first();
        return new EditResponse($assembled_product) ;

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ManageAssembledProductRequest $request, $id)
    {
        // dd($request->all());
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['user_id'] = auth()->user()->id;

        $assembled_product = AssembledProduct::where('id', $id)->with('assembled_product_items')->first();
        try {
            $this->repository->update($assembled_product, $input);
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler('Error updating assembled products', $th);
        }

        return new RedirectResponse(route('biller.assembled-products.index'), ['flash_success' => 'Assembled products were updated successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $assembled_product = AssembledProduct::where('id',$id)->with('material_issuing_items')->first();

        try {
            $this->repository->delete($assembled_product);
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler($th, 'Error deleting assembled products');
        }

        return new RedirectResponse(route('biller.material-issuing.index'), ['flash_success' => 'Assembled products deleted successfully.']);
    }

    public function getReportView(){
        // $stations = AssemblyStation::all();
        $products = Product::all();
        // $warehouses = Warehouse::all();
        return view('focus.assembly.assembled_product.assembled_product_report', compact('products'));
    }
}
