<?php

namespace App\Http\Controllers\Focus\assembly\assembly_station;

use App\Http\Controllers\Controller;
use App\Http\Requests\Focus\assembly\assembly_stations\CreateAssemblyStationsRequest;
use App\Http\Requests\Focus\assembly\assembly_stations\DeleteAssemblyStationsRequest;
use App\Http\Requests\Focus\assembly\assembly_stations\ManageAssemblyStationsRequest;
use App\Http\Requests\Focus\assembly\assembly_stations\StoreAssemblyStationsRequest;
use App\Http\Requests\Focus\assembly\assembly_stations\UpdateAssemblyStationsRequest;
use App\Repositories\Focus\assembly\AssemblyStationRepository;
use Illuminate\Http\Request;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\assembly\assembly_stations\CreateResponse;
use App\Http\Responses\RedirectResponse;
use App\Models\assembly\assembly_station\AssemblyStation;
use App\Http\Responses\Focus\assembly\assembly_stations\EditResponse;

class AssemblyStationController extends Controller
{
    protected $repository;

    public function __construct(AssemblyStationRepository $repository)
    {
        $this->repository = $repository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ManageAssemblyStationsRequest $request)
    {
        return new ViewResponse('focus.assembly.assembly_station.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(CreateAssemblyStationsRequest $request)
    {
        return new CreateResponse('focus.assembly.assembly_station.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreAssemblyStationsRequest $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['tid'] = $request->tid;

        // dd($input);
        try {
            $this->repository->create($input);
        } catch (\Throwable $th) {
            // dd($th);
            return errorHandler('Error Creating Station', $th);
        }

        return new RedirectResponse(route('biller.assembly-station.index'), ['flash_success' => 'Station created successfully']);

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(ManageAssemblyStationsRequest $request, $id)
    {
        $assembly_station = AssemblyStation::find($id);
        return new ViewResponse('focus.assembly.assembly_station.view', compact('assembly_station'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(ManageAssemblyStationsRequest $request, $id)
    {
        $assembly_station = AssemblyStation::find($id);
        return new EditResponse($assembly_station);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateAssemblyStationsRequest $request, $id)
    {

        $input = $request->all();
        $assembly_station = AssemblyStation::find($id);


        try {
            $this->repository->update($assembly_station, $input);
        } catch (\Throwable $th) {
            return errorHandler($th, 'Error Updating Assembly Station');
        }

        return new RedirectResponse(route('biller.assembly-station.index'), ['flash_success' => 'Assembly Station Updated Successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(DeleteAssemblyStationsRequest $request, $id)
    {
        $assembly_station = AssemblyStation::find($id);

        try {
            $this->repository->delete($assembly_station);
        } catch (\Throwable $th) {
            return errorHandler($th, 'Error Deleting Assembly Station');
        }
        return new RedirectResponse(route('biller.assembly-station.index'), ['flash_success' => 'Assembly Station Deleted Successfully']);


        // return json_encode(['status' => 'Success', 'message' => 'Assembly station deleted successfully']);
    }

    public function select(ManageAssemblyStationsRequest $request){
        $q = $request->keyword;
        $assembly_stations = AssemblyStation::where('name', 'LIKE', '%'.$q.'%')
            // ->where('active', 1)->orWhere('email', 'LIKE', '%'.$q.'')
            ->limit(6)->get(['id', 'name']);

        return response()->json($assembly_stations);
    }
}
