<?php

namespace App\Http\Controllers\Focus\assembly\material_issuing;

use App\Http\Controllers\Controller;
use App\Http\Requests\Focus\assembly\material_issuing\CreateMaterialIssuingRequest;
use App\Http\Requests\Focus\assembly\material_issuing\DeleteMaterialIssuingRequest;
use App\Http\Requests\Focus\assembly\material_issuing\ManageMaterialIssuingRequest;
use App\Http\Requests\Focus\assembly\material_issuing\StoreMaterialIssuingRequest;
use App\Http\Requests\Focus\assembly\material_issuing\UpdateMaterialIssuingRequest;
use App\Repositories\Focus\assembly\MaterialIssuingRepository;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\assembly\material_issuing\CreateResponse;
use App\Http\Responses\Focus\assembly\material_issuing\EditResponse;
use App\Http\Responses\RedirectResponse;
use App\Models\assembly\material_issuing\MaterialIssuing;
use App\Models\assembly\material_issuing\MaterialIssuingItems;
use Illuminate\Support\Arr;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\Access\User\User;
use App\Models\assembly\assembly_station\AssemblyStation;
use App\Models\product\Product;
use App\Models\warehouse\Warehouse;

class MaterialIssuingController extends Controller
{
    protected $repository;

    public function __construct(MaterialIssuingRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ManageMaterialIssuingRequest $request)
    {
        $stations = AssemblyStation::all();
        return new ViewResponse('focus.assembly.material_issuing.index',compact('stations'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(CreateMaterialIssuingRequest $request)
    {
        return new CreateResponse('focus.assembly.material_issuing.create');
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreMaterialIssuingRequest $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['user_id'] = auth()->user()->id;

        $data_items = Arr::only($input, ['product_id', 'current_stock_quantity', 'quantity_issued','uom','unit_cost','total_cost']);
        $data_items = modify_array($data_items);
        $data_items = array_filter($data_items, fn($v) => $v['quantity_issued'] > 0);
        // $data_items = array_unique($data_items, SORT_REGULAR);


        foreach ($data_items as $i => $item) {
            if($item['quantity_issued'] > $item['current_stock_quantity']){
                return new RedirectResponse(route('biller.material-issuing.create'), ['flash_error' => 'Materials issued cannot be more than current stock quantity.']);
            }
        }



        try {
            $this->repository->create($input);
        } catch (\Throwable $th) {
            // dd($th);
            return errorHandler('Error Creating Product', $th);
        }

        return new RedirectResponse(route('biller.material-issuing.index'), ['flash_success' => 'Materials issued successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(ManageMaterialIssuingRequest $request ,$id)
    {
        $material_issuing = MaterialIssuing::where('id',$id)->with('material_issuing_items')->first();
        return new ViewResponse('focus.assembly.material_issuing.view', compact('material_issuing'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(ManageMaterialIssuingRequest $request,$id)
    {
        $material_issuing = MaterialIssuing::where('id',$id)->with('material_issuing_items')->first();
        return new EditResponse($material_issuing);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateMaterialIssuingRequest $request, $id)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['user_id'] = auth()->user()->id;

        $data_items = Arr::only($input, ['product_id', 'current_stock_quantity', 'quantity_issued','uom','unit_cost','total_cost']);
        $data_items = modify_array($data_items);
        $data_items = array_filter($data_items, fn($v) => $v['quantity_issued'] > 0);

        foreach ($data_items as $i => $item) {
            if($item['quantity_issued'] > $item['current_stock_quantity']){
                return redirect()->back()->with(['flash_error' => 'Materials issued cannot be more than current stock quantity.']);
            }
        }

        $material_issuing = MaterialIssuing::where('id',$id)->with('material_issuing_items')->first();

        try {
            $this->repository->update($material_issuing, $input);
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler($th, 'Error Updating Material Issue');
        }

        return new RedirectResponse(route('biller.material-issuing.index'), ['flash_success' => 'Material Issue updated successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(DeleteMaterialIssuingRequest $request ,$id)
    {
        $material_issuing = MaterialIssuing::where('id',$id)->with('material_issuing_items')->first();

        try {
            $this->repository->delete($material_issuing);
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler($th, 'Error Deleting Material Issuing');
        }

        return new RedirectResponse(route('biller.material-issuing.index'), ['flash_success' => 'Material Issue deleted successfully.']);
    }

    public function getMaterialIssuingReportView(){
        $stations = AssemblyStation::all();
        $products = Product::all();
        $warehouses = Warehouse::all();
       return view('focus.assembly.material_issuing.material_issuing_report', compact('stations', 'warehouses', 'products'));
    }

    public function getMaterialIssuingReport(Request $request){

        $data = MaterialIssuingItems::all();
        // dd($data);


    }

    public function printPDF($id){
        $material_issuing = MaterialIssuing::where('id',$id)->with('material_issuing_items')->first();
        // dd($material_issuing);

        $pdfContent = Pdf::loadView('focus.assembly.material_issuing.mir', [
            'material_issuing' => $material_issuing,
          ])
            ->setPaper('a4', 'landscape')
            ->output();

        return response()->streamDownload(
            fn() => print $pdfContent,
            'MaterialIssue-'.$material_issuing->tid .'.pdf',
            [
              'Content-Type' => 'application/pdf',
            ],
            'inline'
          );



        // return view('focus.assembly.material_issuing.mir', compact('material_issuing'));
    }
}
