<?php

namespace App\Http\Controllers\Focus\bom;

use App\Http\Controllers\Controller;
use App\Models\bom\BoM;
use App\Repositories\Focus\bom\BoMRepository;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class BoMTableController extends Controller
{
    const MODEL = BoM::class;

    protected $bom;

    public function __construct(BoMRepository $bom)
    {
        $this->bom = $bom;
    }

    public function __invoke()
    {
        $core = $this->bom->getForDataTable();

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('title', function ($bom) {
                return $bom->title;
            })
            ->addColumn('tid', function ($bom) {
                return  gen4tid('BOM-',$bom->tid);
            })
            ->addColumn('description', function ($bom) {
                return  $bom->description;
            })
            ->addColumn('jobcard_no', function ($bom) {
                return  $bom->bom_jobcard ? $bom->bom_jobcard->jobcard_no : '';
            })
            ->addColumn('status', function ($bom) {
                return  ucfirst($bom->status);
            })
            ->addColumn('bom_status', function ($bom) {
                return  ucfirst($bom->bom_status);
            })
            ->addColumn('bom_date', function ($bom) {
                return  dateFormat($bom->bom_date);
            })
            ->addColumn('total', function ($bom) {
                return NumberFormat($bom->total);
            })
            ->addColumn('total_bom', function ($bom) {
                return NumberFormat($bom->total_bom);
            })
            ->addColumn('actions', function ($bom) {
                return '<a href="' . route('biller.bom.edit', [$bom, 'task=bom_to_bom']) . '" class="btn btn-warning round" data-toggle="tooltip" data-placement="top" title="Copy"><i  class="fa fa-clone"></i></a>'
                .$bom->action_buttons;
            })
            ->make(true);
    }
}
