<?php

namespace App\Http\Controllers\Focus\brands;

use App\Http\Controllers\Controller;
use App\Models\brand\Brand;
use App\Repositories\Focus\brand\BrandRepository;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Http\Request;

class BrandTableController extends Controller
{
    const MODEL = Brand::class;

    protected $brand;

    public function __construct(BrandRepository $brand)
    {
        $this->brand = $brand;
    }

    public function __invoke()
    {
        $core = $this->brand->getForDataTable();

        // aggregate
        $brands = Brand::count();
        $aggregate = compact('brands');

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('name', function ($brand) {
                return $brand->name;
            })
            ->addColumn('code', function ($brand) {
                return  $brand->code;
            })
            ->addColumn('created_at', function ($brand) {
                return  $brand->created_at->toDateString();
            })
            ->addColumn('actions', function ($brand) {
                return $brand->action_buttons;
            })
            ->addColumn('aggregate', function () use($aggregate) {
                return $aggregate;
            })
            ->make(true);
    }
}
