<?php
/* Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 **
 * Rose Business Suite - Accounting, CRM and POS Software
 
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

namespace App\Http\Controllers\Focus\debitnote;

use App\Http\Controllers\Controller;
use App\Repositories\Focus\debitnote\DebitNoteRepository;
use Yajra\DataTables\Facades\DataTables;

class DebitNotesTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var DebitNoteRepository
     */
    protected $debitnote;

    /**
     * contructor to initialize bill object
     * @param DebitNoteRepository $debitnote ;
     */
    public function __construct(DebitNoteRepository $debitnote)
    {
        $this->debitnote = $debitnote;
    }

    /**
     * This method return the data of the model
     * @return mixed
     */
    public function __invoke()
    {
        $core = $this->debitnote->getForDataTable();

        $ins = auth()->user()->ins;
        $prefixes = prefixesArray(['credit_note', 'debit_note', 'invoice'], $ins);

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('tid', function ($debitnote) use($prefixes) {
                return gen4tid($debitnote->is_debit ? "{$prefixes[1]}-" : "{$prefixes[0]}-", $debitnote->tid);
            })
            ->addColumn('customer', function ($debitnote) {
                return @$debitnote->customer->name;
            })
            ->addColumn('invoice_tid', function ($debitnote) use($prefixes) {
                if ($debitnote->invoice)
                    return '<a class="font-weight-bold" href="' . route('biller.invoices.show', $debitnote->invoice) . '">' 
                        . gen4tid("{$prefixes[2]}-", $debitnote->invoice->tid) . '</a>';
            })
            ->addColumn('amount', function ($debitnote) {
                return number_format($debitnote->total, 2);
            })
            ->addColumn('date', function ($debitnote) {
                return dateFormat($debitnote->date);
            })
            ->addColumn('actions', function ($debitnote) {
                return '<a href="' . route('biller.debitnotes.print_debitnote', $debitnote) . '" target="_blank"  class="btn btn-purple round"><i class="fa fa-print"></i></a> '
                    . $debitnote->action_buttons;
            })
            ->make(true);
    }
}
