<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\invoice;

use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\invoice\InvoiceRepository;
use App\Http\Requests\Focus\invoice\ManageInvoiceRequest;

/**
 * Class InvoicesTableController.
 */
class InvoicesTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var InvoiceRepository
     */
    protected $invoice;
    protected $sum_balance = 0;
    protected $sum_total = 0;

    /**
     * contructor to initialize repository object
     * @param InvoiceRepository $invoice ;
     */
    public function __construct(InvoiceRepository $invoice)
    {
        $this->invoice = $invoice;
    }

    /**
     * This method return the data of the model
     * @param ManageInvoiceRequest $request
     *
     * @return mixed
     */
    public function __invoke(ManageInvoiceRequest $request)
    {
        $query = $this->invoice->getForDataTable();
        $this->sum_total = $query->sum('total');

        return Datatables::of($query)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('customer', function ($invoice) {
                $link = '';
                if ($invoice->customer) {
                    $customer_name = $invoice->customer->company ?: $invoice->customer->name; 
                    $link = ' <a href="'. route('biller.customers.show', $invoice->customer) .'">'. $customer_name .'</a>'; 
                }
                return $link;             
            })
            ->addColumn('tid', function ($invoice) {
                return '<a href="'.route('biller.invoices.show', $invoice->id).'">' . $invoice->tid_code .'</a>';
            })
            ->addColumn('date', function ($invoice) {
                return dateFormat($invoice->date);
            })
            ->addColumn('total', function ($invoice) {
                return numberFormat($invoice->total);
            })
            ->addColumn('balance', function ($invoice) {
                $this->sum_balance += $invoice->amount_received;
                return numberFormat($invoice->amount_received);
            })
            ->addColumn('due_date', function ($invoice) {
                return dateFormat($invoice->due_date);
            })
            ->addColumn('work_order_id', function ($invoice) {
                if (!$invoice->work_order) return;
                return '<a href="'. route('biller.work_orders.show', $invoice->work_order) .'">'. $invoice->work_order->tid_code .'</a>';
            })
            ->addColumn('aggregate', function ($invoice) {
                return [
                    'sum_balance' => numberFormat($this->sum_balance),
                    'sum_total' => numberFormat($this->sum_total),
                ];
            })
            ->addColumn('actions', function ($invoice) {
                return $invoice->action_buttons;
            })
            ->make(true);
    }
}
