<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\jobcard;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\jobcard\JobCardRepository;
use Illuminate\Http\Request;

/**
 * Class jobcardsTableController.
 */
class JobCardsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var jobcardRepository
     */
    protected $jobcard;

    /**
     * contructor to initialize repository object
     * @param jobcardRepository $jobcard ;
     */
    public function __construct(JobCardRepository $jobcard)
    {
        $this->jobcard = $jobcard;
    }

    /**
     * This method return the data of the model
     * @param ManagejobcardRequest $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        //
        $core = $this->jobcard->getForDataTable();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('name', function ($jobcard) {
                $customer = $jobcard->customer ? $jobcard->customer->company : '';
                return $customer;
            })
            ->addColumn('bom_name', function ($jobcard) {
                $bom = $jobcard->bom ? $jobcard->bom->title : '';
                return $bom;
            })
            ->addColumn('jobcard_date', function ($jobcard) {
                return dateFormat($jobcard->jobcard_date);
            })
            ->addColumn('total_qty', function ($jobcard) {
                return NumberFormat($jobcard->total_qty);
            })
            ->addColumn('total_board', function ($jobcard) {
                return NumberFormat($jobcard->total_board);
            })
            ->addColumn('status', function ($jobcard) {
                return ucfirst($jobcard->status);
            })
            ->addColumn('job_status', function ($jobcard) {
                return ucfirst($jobcard->job_status);
            })
            ->addColumn('created_at', function ($jobcard) {
                return Carbon::parse($jobcard->created_at)->toDateString();
            })
            ->addColumn('actions', function ($jobcard) {

                return '<a href="' . route('biller.jobcards.edit', [$jobcard, 'task=jobcard_to_jobcard']) . '" class="btn btn-warning round" data-toggle="tooltip" data-placement="top" title="Copy"><i  class="fa fa-clone"></i></a>'
                .$jobcard->action_buttons;
            })
            ->make(true);
    }
}
