<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\paper;

use App\Models\paper\Paper;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\paper\CreateResponse;
use App\Http\Responses\Focus\paper\EditResponse;
use App\Repositories\Focus\paper\PaperRepository;
use App\Models\supplier\Supplier;
use App\Models\gsm\GSM;
use App\Models\paper_width\PaperWidth;
use App\Models\paper\PaperName;


/**
 * papersController
 */
class PapersController extends Controller
{
    /**
     * variable to store the repository object
     * @var paperRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param paperRepository $repository ;
     */
    public function __construct(PaperRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\paper\Request $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(Request $request)
    {
        $suppliers = Supplier::get();
        // $paper_widths = PaperWidth::all(['id', 'name']);
        // $gsms = GSM::all(['id', 'name']);
        $paper_widths = PaperName::where('type', '1')->get(['id','name']);
        $gsms = PaperName::where('type', '2')->get(['id','name']);
        return new ViewResponse('focus.papers.index', compact('suppliers','paper_widths','gsms'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param CreatepaperRequestNamespace $request
     * @return \App\Http\Responses\Focus\paper\CreateResponse
     */
    public function create(Request $request)
    {
        return new CreateResponse('focus.papers.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param RequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(Request $request)
    {
        //Input received from the request
        $input = $request->except(['_token', 'ins']);
        $input['ins'] = auth()->user()->ins;
        try {
            //Create the model using repository create method
            $this->repository->create($input);
        } catch (\Throwable $th) {
            return errorHandler('Error Creating papers', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.papers.index'), ['flash_success' => 'Paper Created Successfully!!']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\paper\paper $paper
     * @param EditpaperRequestNamespace $request
     * @return \App\Http\Responses\Focus\paper\EditResponse
     */
    public function edit(Paper $paper, Request $request)
    {
        return new EditResponse($paper);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdatepaperRequestNamespace $request
     * @param App\Models\paper\paper $paper
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(Request $request, Paper $paper)
    {
        //Input received from the request
        $input = $request->except(['_token', 'ins']);
        try {
            //Update the model using repository update method
            $this->repository->update($paper, $input);
        } catch (\Throwable $th) {
            return errorHandler('Error Updating papers', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.papers.index'), ['flash_success' => 'Paper Updated Successfully!!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletepaperRequestNamespace $request
     * @param App\Models\paper\paper $paper
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(Paper $paper, Request $request)
    {
        try {
            //Calling the delete method on repository
            $this->repository->delete($paper);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting papers', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.papers.index'), ['flash_success' => 'Paper Deleted Successfully!!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletepaperRequestNamespace $request
     * @param App\Models\paper\paper $paper
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show(Paper $paper, Request $request)
    {

        //returning with successfull message
        return new ViewResponse('focus.papers.view', compact('paper'));
    }

}
