<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\paper;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\paper\PaperRepository;
use Illuminate\Http\Request;

/**
 * Class papersTableController.
 */
class PapersTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var paperRepository
     */
    protected $paper;

    /**
     * contructor to initialize repository object
     * @param paperRepository $paper ;
     */
    public function __construct(PaperRepository $paper)
    {
        $this->paper = $paper;
    }

    /**
     * This method return the data of the model
     * @param Request $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        //
        $core = $this->paper->getForDataTable();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('paper_width', function ($paper) {
                //dd($paper->paper_width);
                return $paper->paper_width ? $paper->paper_width->name : '';
            })
            ->addColumn('gsm', function ($paper) {
               // dd($paper->gsm);
                return $paper->gsm ? $paper->gsm->name : '';
            })
            ->addColumn('supplier', function ($paper) {
                return $paper->supplier ? $paper->supplier->name : '';
            })
            ->addColumn('price', function ($paper) {
                return NumberFormat($paper->price);
            })

            ->addColumn('created_at', function ($paper) {
                return Carbon::parse($paper->created_at)->toDateString();
            })
            ->addColumn('actions', function ($paper) {
                return $paper->action_buttons;
            })
            ->make(true);
    }
}
