<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\paper_width;

use App\Models\paper_width\PaperWidth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\paper_width\CreateResponse;
use App\Http\Responses\Focus\paper_width\EditResponse;
use App\Repositories\Focus\paper_width\PaperWidthRepository;


/**
 * paper_widthController
 */
class PaperWidthsController extends Controller
{
    /**
     * variable to store the repository object
     * @var paperRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param paperRepository $repository ;
     */
    public function __construct(PaperWidthRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\paper\Request $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(Request $request)
    {
        return new ViewResponse('focus.paper_widths.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param CreatepaperRequestNamespace $request
     * @return \App\Http\Responses\Focus\paper\CreateResponse
     */
    public function create(Request $request)
    {
        return new CreateResponse('focus.paper_widths.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param RequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(Request $request)
    {
        //Input received from the request
        $input = $request->except(['_token', 'ins']);
        $input['ins'] = auth()->user()->ins;
        $input['user_id'] = auth()->user()->id;
        try {
            //Create the model using repository create method
            $this->repository->create($input);
        } catch (\Throwable $th) {
            return errorHandler('Error Creating paper_width', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.paper_widths.index'), ['flash_success' => 'Paper Width Created Successfully!!']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\paper\paper $paper
     * @param EditpaperRequestNamespace $request
     * @return \App\Http\Responses\Focus\paper\EditResponse
     */
    public function edit(PaperWidth $paper_width, Request $request)
    {
        return new EditResponse($paper_width);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdatepaperRequestNamespace $request
     * @param App\Models\paper\paper $paper
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(Request $request, PaperWidth $paper_width)
    {
        //Input received from the request
        $input = $request->except(['_token', 'ins']);
        try {
            //Update the model using repository update method
            $this->repository->update($paper_width, $input);
        } catch (\Throwable $th) {
            return errorHandler('Error Updating paper_width', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.paper_widths.index'), ['flash_success' => 'Paper Width Updated Successfully!!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletepaperRequestNamespace $request
     * @param App\Models\paper\paper $paper
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(PaperWidth $paper_width, Request $request)
    {
        try {
            //Calling the delete method on repository
            $this->repository->delete($paper_width);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting paper_width', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.paper_widths.index'), ['flash_success' => 'Paper Width Deleted Successfully!!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletepaperRequestNamespace $request
     * @param App\Models\paper\paper $paper
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show(PaperWidth $paper_width, Request $request)
    {

        //returning with successfull message
        return new ViewResponse('focus.paper_widths.view', compact('paper_width'));
    }

}
