<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\paper_width;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\paper_width\PaperWidthRepository;
use Illuminate\Http\Request;

/**
 * Class papersTableController.
 */
class PaperWidthsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var paperRepository
     */
    protected $paper_width;

    /**
     * contructor to initialize repository object
     * @param paperRepository $paper_width ;
     */
    public function __construct(PaperWidthRepository $paper_width)
    {
        $this->paper_width = $paper_width;
    }

    /**
     * This method return the data of the model
     * @param Request $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        //
        $core = $this->paper_width->getForDataTable();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('name', function ($paper_width) {
                
                return $paper_width->name;
            })
            ->addColumn('paper_type', function ($paper_width) {
                return $paper_width->paper_type;
            })
            ->addColumn('width', function ($paper_width) {
                return $paper_width->width;
            })
            ->addColumn('uom', function ($paper_width) {
                return $paper_width->unit ? $paper_width->unit->code : '';
            })
            ->addColumn('created_at', function ($paper_width) {
                return Carbon::parse($paper_width->created_at)->toDateString();
            })
            ->addColumn('actions', function ($paper_width) {
                return $paper_width->action_buttons;
            })
            ->make(true);
    }
}
