<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\print_design;

use App\Models\print_design\PrintDesign;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\print_design\CreateResponse;
use App\Http\Responses\Focus\print_design\EditResponse;
use App\Repositories\Focus\print_design\PrintDesignRepository;
use App\Models\customer\Customer;


/**
 * print_designsController
 */
class PrintDesignsController extends Controller
{
    /**
     * variable to store the repository object
     * @var print_designRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param print_designRepository $repository ;
     */
    public function __construct(PrintDesignRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\print_design\Manageprint_designRequest $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(Request $request)
    {
        $customers = Customer::all(['id', 'company']);
        $print_designs = PrintDesign::all();
        return new ViewResponse('focus.print_designs.index',compact('customers','print_designs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Createprint_designRequestNamespace $request
     * @return \App\Http\Responses\Focus\print_design\CreateResponse
     */
    public function create(Request $request)
    {
        return new CreateResponse('focus.print_designs.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Storeprint_designRequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(Request $request)
    {
        // dd($request->all());
        //Input received from the request
        $input['print'] = $request->only(['customer_id', 'status','design','description']);
        $input['print']['ins'] = auth()->user()->ins;
        $input['print']['user_id'] = auth()->user()->id;
        foreach ($input as $key => $val) {
            // dd($val);
            if ($key == 'print') {
                if (isset($val['design'])) $request->validate(['design' => 'required|mimes:jpeg,jpg,png,pdf']);
            }
        }
        // dd($input);
        try {
            //Create the model using repository create method
            $this->repository->create($input);
        } catch (\Throwable $th) {
            return errorHandler('Error Creating PrintDesigns', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.print_designs.index'), ['flash_success' => trans('alerts.backend.print_designs.created')]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\print_design\print_design $print_design
     * @param Editprint_designRequestNamespace $request
     * @return \App\Http\Responses\Focus\print_design\EditResponse
     */
    public function edit(PrintDesign $print_design, Request $request)
    {
        return new EditResponse($print_design);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Updateprint_designRequestNamespace $request
     * @param App\Models\print_design\print_design $print_design
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(Request $request, PrintDesign $print_design)
    {
        //Input received from the request
        $input['print'] = $request->only(['customer_id', 'status','design','description']);
        $input['print']['ins'] = auth()->user()->ins;
        $input['print']['user_id'] = auth()->user()->id;
        // dd($input);
        foreach ($input as $key => $val) {
            // dd($val);
            if ($key == 'print') {
                if (isset($val['design'])) $request->validate(['design' => 'required|mimes:jpeg,jpg,png,pdf']);
            }
        }
        try {
            //Update the model using repository update method
            $this->repository->update($print_design, $input);
        } catch (\Throwable $th) {
            return errorHandler('Error Updating print_designs', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.print_designs.index'), ['flash_success' => trans('alerts.backend.print_designs.updated')]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Deleteprint_designRequestNamespace $request
     * @param App\Models\print_design\print_design $print_design
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(PrintDesign $print_design, Request $request)
    {
        try {
            //Calling the delete method on repository
            $this->repository->delete($print_design);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting print_designs', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.print_designs.index'), ['flash_success' => trans('alerts.backend.print_designs.deleted')]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Deleteprint_designRequestNamespace $request
     * @param App\Models\print_design\print_design $print_design
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show(PrintDesign $print_design, Request $request)
    {

        //returning with successfull message
        return new ViewResponse('focus.print_designs.view', compact('print_design'));
    }

}
