<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\print_design;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\print_design\PrintDesignRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
/**
 * Class print_designsTableController.
 */
class PrintDesignsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var PrintDesignRepository
     */
    protected $print_design;

    /**
     * contructor to initialize repository object
     * @param print_designRepository $print_design ;
     */
    public function __construct(PrintDesignRepository $print_design)
    {
        $this->print_design = $print_design;
    }

    /**
     * This method return the data of the model
     * @param Request $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        //
        $print_designs = $this->print_design->getForDataTable();
        $data = [];
        foreach ($print_designs as $design) {
            // dd($design);route('biller.print_designs.destroy', $design->id)
            $d_type = "data";
            $datas = '
            <div class="col-md-6 mb-4 round">
                <div class="card round">
                    <div class="card-body round dflex-column justify-content-center">
                        <div class="row float-right mt-1">

                            <a href="'.route('biller.print_designs.edit', $design->id).'" class="btn btn-primary  round" data-toggle="tooltip" data-placement="top" title="Edit"><i  class="fa fa-pencil "></i></a>
                            <a href="'.route('biller.print_designs.destroy', $design->id).'" 
                                class="btn btn-danger round"  data-toggle="tooltip" data-placement="top" title="Delete"
                            >
                                <i  class="fa fa-trash"></i>
                            </a>
                        </div>
                        <div class="row float-right mt-5">

                        </div>
                        <h5 class="card-title row">

                            <img class="zoom"
                                src="'.asset('storage/img/designs/'.$design->design).'"
                                alt="Image">
                        </h5>
                        <h4 class="card-text mt-2 row">'.$design->description.'</h4>
                        <p class="card-text row"><small class="text-muted">'.@$design->customer->company.'</small></p>
                    </div>
                </div>
            </div>
            ';
            $data[] = $datas;
            # code...
        }
        return response()->json($data);
      
    }
}
