<?php

namespace App\Http\Controllers\Focus\product;

use App\Http\Controllers\Controller;
use App\Models\product\Product;
use Illuminate\Http\Request;
use DB;
use Barryvdh\DomPDF\Facade\Pdf;

class ProductBarcodeController extends Controller
{
    public function printProductBarCodes(Request $request){
        $products = $request->v_codes;

        $data = [];
        foreach($products as $product) {
            $productData = Product::where('id', $product)->first();
            $data['name'] = $productData->name;
            $data['sku'] = $productData->sku;
            $productsToPrint[] = $data;
        }

        $pdfContent = Pdf::loadView('focus.bill.print_barcode', [
            'productsToPrint' => $productsToPrint,
          ])
            ->setPaper(array(0,0,100.763538,100.763538))
            ->set_option('enable_css', true)
            ->set_option('css_preload', true)
            ->output();

          return response()->streamDownload(
            fn() => print $pdfContent,
            'product_barcodes.pdf',
            [
              'Content-Type' => 'application/pdf',
            ],
            'inline'
          );
    }
}
