<?php

namespace App\Http\Controllers\Focus\product;

use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\product\ProductRepository;
use App\Http\Requests\Focus\product\ManageProductRequest;
use DB;

class ProductBarcodeTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var ProductRepository
     */
    protected $repository;

    /**
     * Constructor to initialize repository object
     * @param ProductRepository $repository ;
     */
    public function __construct(ProductRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * This method return the data of the model
     * @param ManageProductRequest $request
     * @return mixed
     */
    public function __invoke()
    {
        $core = $this->repository->getProductsForBarCodes();

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('mass_select', function ($product) {
                return  '<input type="checkbox"  name="v_codes[]" class="row-select" value=" '. $product->id .'">';
            })
            ->addColumn('name', function ($product) {
                return $product->name;
            })
            ->addColumn('sku', function ($product) {
                return  $product->sku;
            })
            ->addColumn('location', function ($product) {
                return $product->warehouse ? $product->warehouse->title : '--';
            })
            ->addColumn('qty', function ($product) {
                return $product->variations->sum('qty');
            })
            ->addColumn('unit', function ($product) {
                return $product->unit ? $product->unit->title : '--';
            })
            ->addColumn('actions', function ($product) {
                return $product->action_buttons;
            })
            ->make(true);
    }
}

