<?php

namespace App\Http\Controllers\Focus\productcombination;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Responses\Focus\productcombination\CreateResponse;
use App\Models\product\Product;
use App\Models\product\ProductVariation;
use App\Models\productcategory\Productcategory;
use App\Models\warehouse\Warehouse;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\product\CreateModalResponse;
use App\Http\Responses\Focus\product\EditResponse;
use App\Repositories\Focus\product\ProductRepository;
use App\Http\Requests\Focus\product\ManageProductRequest;
use App\Http\Requests\Focus\product\CreateProductRequest;
use App\Http\Requests\Focus\product\EditProductRequest;
use App\Models\client_product\ClientProduct;
use App\Models\supplier_product\SupplierProduct;
use App\Models\product\ProductMeta;
use DB;
use Illuminate\Support\Arr;
use App\Models\productcombination\ProductCombination;
use App\Models\productvariable\Productvariable;
use App\Models\productcombination\ProductProcessing;


class ProductProcessingController extends Controller
{
    public function store(Request $request){
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['stock_type'] = "processed";

        $sku_exists = Product::where('sku', $input['sku'])->count();
        if (empty($input['sku']) || $sku_exists) {
            $input['sku'] = substr($input['name'], 0, 1) . substr($input['name'], -1) . rand(1, 10000);
        }

        try{
            DB::beginTransaction();
            $product = Product::create($input);


            if($product){
                $variation = ProductVariation::create([
                    'parent_id' => $product->id,
                    'purchase_price' => 0,
                    'minimum_selling_price' => $input['minimum_selling_price'],
                    'recommended_selling_price' => $input['recommended_selling_price'],
                    'alert' => $input['alert'],
                    'expiry' => $input['expiry'] ?? 0,
                    'warehouse_id' => $input['warehouse_id'],
                    'warehouse_row_id' => $input['warehouse_row_id'] ?? 1,
                    'warehouse_shelf_id' => $input['warehouse_shelf_id'] ?? 1,
                    'ins' => $input['ins'],
                ]);

                if($variation && $input['product_serial'] != null){
                    $product_serial = DB::table('product_meta')->insert([
                        'rel_type' => $product->id,
                        'rel_id' => $variation->id,
                        'value' => $input['product_serial'],
                        ]
                    );
                }
            }


            $product_processing = DB::table('product_processings')->insert([
                'product_id' => $product->id,
                'product_quantity' => $input['quantity'],
                'raw_material' => $input['raw_material'],
                'raw_material_quantity' => $input['raw_material_quantity']
            ]);

            DB::commit();

        }catch(\Throwable $th){
            return errorHandler('Error Creating Product', $th);
        }

        return new RedirectResponse(route('biller.products.index'), ['flash_success' => trans('alerts.backend.products.updated')]);

    }
}
