<?php

namespace App\Http\Controllers\Focus\productcombination;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Responses\ViewResponse;
use App\Models\product\Product;
use App\Models\productcategory\Productcategory;
use App\Models\warehouse\Warehouse;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\Focus\productprocessing\CreateResponse;
use App\Http\Responses\Focus\product\CreateModalResponse;
use App\Http\Responses\Focus\product\EditResponse;
use App\Repositories\Focus\product\ProductRepository;
use App\Http\Requests\Focus\product\ManageProductRequest;
use App\Http\Requests\Focus\product\CreateProductRequest;
use App\Http\Requests\Focus\product\EditProductRequest;
use App\Models\client_product\ClientProduct;
use App\Models\supplier_product\SupplierProduct;
use App\Models\product\ProductMeta;
use DB;
use App\Models\product\ProductVariation;
use App\Models\productvariable\Productvariable;
use Illuminate\Contracts\Support\Responsable;

class ProductProcessingController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $warehouses = Warehouse::get(['id', 'title']);
        $categories = Productcategory::get(['id', 'title']);


        return new ViewResponse('focus.productcombinations.processed.index', compact('warehouses','categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return new CreateResponse('focus.productcombinations.processed.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['stock_type'] = "processed";

        $sku_exists = Product::where('sku', $input['sku'])->count();
        if (empty($input['sku']) || $sku_exists) {
            $input['sku'] = substr($input['name'], 0, 1) . substr($input['name'], -1) . rand(1, 10000);
        }

        try{
            DB::beginTransaction();
            $product = Product::create($input);


            if($product){
                $variation = ProductVariation::create([
                    'parent_id' => $product->id,
                    'purchase_price' => 0,
                    'minimum_selling_price' => $input['minimum_selling_price'],
                    'recommended_selling_price' => $input['recommended_selling_price'],
                    'alert' => $input['alert'],
                    'expiry' => $input['expiry'] ?? 0,
                    'warehouse_id' => $input['warehouse_id'],
                    'warehouse_row_id' => $input['warehouse_row_id'] ?? 1,
                    'warehouse_shelf_id' => $input['warehouse_shelf_id'] ?? 1,
                    'ins' => $input['ins'],
                ]);

                if($variation && $input['product_serial'] != null){
                    $product_serial = DB::table('product_meta')->insert([
                        'rel_type' => $product->id,
                        'rel_id' => $variation->id,
                        'value' => $input['product_serial'],
                        ]
                    );
                }
            }


            $product_processing = DB::table('product_processings')->insert([
                'product_id' => $product->id,
                'product_quantity' => $input['quantity'],
                'raw_material' => $input['raw_material'],
                'raw_material_quantity' => $input['raw_material_quantity']
            ]);

            DB::commit();

        }catch(\Throwable $th){
            return errorHandler('Error Creating Product', $th);
        }

        return new RedirectResponse(route('biller.productcombinations.processed.index'), ['flash_success' => trans('alerts.backend.products.updated')]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $processed_product = Product::where('id', $id)->first();
        dd($processed_product);
        return new ViewResponse('focus.productcombinations.processed.view',compact('processed_product'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
