<?php

namespace App\Http\Controllers\Focus\productcombination;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Focus\productcombination\ProductProcessingRepository;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\product\ProductRepository;
use App\Http\Requests\Focus\product\ManageProductRequest;
use DB;

class ProductProcessingTableController extends Controller
{
    protected $repository;

    // protected $processed_product;

    public function __construct(ProductProcessingRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke()
    {
        $core = $this->repository->getForDataTable();

        $product_count = 0;
        $product_worth = 0;
        // foreach ($core as $product) {
        //     $product_count += $product->variations()->count();
        //     $product_worth += $product->variations()->sum(DB::raw('purchase_price*qty'));
        // }
        $product_worth = amountFormat($product_worth);
        $aggregate = compact('product_count', 'product_worth');

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('name', function ($processed_product) {
                // if ($product->standard) {
                //     $this->standard_product = $product->standard;
                    return '<a class="font-weight-bold" href="' . route('biller.processed-products.show', [$processed_product->id]) . '">' . "{$processed_product->name}" . '</a>';
                // }
                // $this->standard_product = $product->standard ?: $product;
                // return '<a class="font-weight-bold" href="' . route('biller.products.show', [$product->id]) . '">' . $product->name . '</a>';
            })
            ->addColumn('code', function ($processed_product) {
                return  $processed_product->code;
            })
            ->addColumn('location', function ($processed_product) {
                return $processed_product->warehouse_row_id .'-'.$processed_product->warehouse_shelf_id;
                // return  $this->standard_product->code;
            })
            ->addColumn('qty', function ($processed_product) {
                return 0;
                // return $product->variations->sum('qty');
            })
            ->addColumn('unit', function ($processed_product) {
                return "unit";
                // $unit = $processed_product->unit;
                // if ($unit) return $unit->code;
            })
            ->addColumn('purchase_price', function ($processed_product) {
                return NumberFormat($processed_product->purchase_price);
            })
            ->addColumn('total', function ($processed_product) {
                $total = 0;
                // foreach ($product->variations as $product_var) {
                //     $total += $this->standard_product->purchase_price * $product_var->qty;
                // }
                return NumberFormat($total);
            })
            ->addColumn('created_at', function ($processed_product) {
                return dateFormat($processed_product->created_at);
            })
            ->addColumn('actions', function ($processed_product) {
                return $processed_product->action_buttons;
            })
            ->addColumn('aggregate', function () use($aggregate) {
                return $aggregate;
            })
            ->make(true);
    }
}
