<?php

namespace App\Http\Controllers\Focus\productconversion;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Focus\productconversion\ProductConversionRepository;
use App\Http\Requests\Focus\productconversion\ManageProductConversionRequest;
use App\Http\Responses\ViewResponse;
use App\Http\Requests\Focus\productconversion\StoreProductConversionRequest;
use App\Http\Responses\Focus\productconversion\CreateResponse;
use App\Http\Responses\RedirectResponse;
use App\Models\productconversion\ProductConversion;
use App\Models\productconversion\ProductConversionRawMaterials;
use Illuminate\Support\Arr;
use App\Http\Responses\Focus\productconversion\EditResponse;

class ProductConversionController extends Controller
{
    protected $repository;

    public function __construct(ProductConversionRepository $repository){
        $this->repository = $repository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ManageProductConversionRequest $request)
    {
        return new ViewResponse('focus.productconversion.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(StoreProductConversionRequest $request)
    {
        return new CreateResponse('focus.productconversion.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreProductConversionRequest $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;

       try{
            $this->repository->create($input);
        }catch(\Throwable $th){
            return errorHandler('Error Creating Product Conversion', $th);
        }

        return new RedirectResponse(route('biller.product-conversion.index'), ['flash_success' => 'Product conversion created successfully']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, ManageProductConversionRequest $request)
    {
        $product_conversion = ProductConversion::where('id', $id)
                            ->with('product_conversion_raw_materials')
                            ->first();

        return new ViewResponse('focus.productconversion.view', compact('product_conversion'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $product_conversion = ProductConversion::where('id', $id)
                            ->with('product_conversion_raw_materials')
                            ->first();
        return new EditResponse($product_conversion);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(StoreProductConversionRequest $request, $id)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;

        try{
            $this->repository->update($input, $id);
        }catch(\Throwable $th){
            return errorHandler('Error Updating Product Conversion', $th);
        }

        return new RedirectResponse(route('biller.product-conversion.index'), ['flash_success' => 'Product conversion updated successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
