<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

namespace App\Http\Controllers\Focus\purchaseorder;

use App\Models\purchaseorder\Purchaseorder;
use App\Http\Controllers\Controller;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\purchaseorder\EditResponse;
use App\Repositories\Focus\purchaseorder\PurchaseorderRepository;

use App\Http\Requests\Focus\purchaseorder\StorePurchaseorderRequest;
use App\Http\Responses\Focus\purchaseorder\CreateResponse;
use App\Http\Responses\RedirectResponse;
use App\Models\supplier\Supplier;
use App\Models\purchase_request\PurchaseRequestItem;
use App\Models\additional\Additional;
use App\Models\pricegroup\Pricegroup;
use App\Models\term\Term;
use App\Models\currency\Currency;
use Carbon\Carbon;
use Illuminate\Http\Request;

/**
 * PurchaseordersController
 */
class PurchaseordersController extends Controller
{
    /**
     * variable to store the repository object
     * @var PurchaseorderRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param PurchaseorderRepository $repository ;
     */
    public function __construct(PurchaseorderRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\purchaseorder\ManagePurchaseorderRequest $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index()
    {
        $suppliers = Supplier::whereHas('purchase_orders')->get(['id', 'name']);

        return new ViewResponse('focus.purchaseorders.index', compact('suppliers'));
    }
    public function index_expense()
    {
        $suppliers = Supplier::whereHas('purchase_orders')->get(['id', 'name']);

        return new ViewResponse('focus.purchaseorders.index_expense', compact('suppliers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param CreatePurchaseorderRequestNamespace $request
     * @return \App\Http\Responses\Focus\purchaseorder\CreateResponse
     */
    public function create(StorePurchaseorderRequest $request)
    {
        return new CreateResponse('focus.purchaseorders.create');
    }
    public function create_expense(StorePurchaseorderRequest $request)
    {
        $ins = auth()->user()->ins;
        $prefixes = prefixesArray(['purchase_order'], $ins);
        $last_tid = Purchaseorder::where('ins', $ins)->max('tid');

        $additionals = Additional::all();
        $pricegroups = Pricegroup::all();
        $supplier = Supplier::where('name', 'Walk-in')->first(['id', 'name']);
        $price_supplier = Supplier::whereHas('products')->get(['id', 'name']);
        // Purchase order
        $terms = Term::where('type', 4)->get();
        $currency = Currency::all();

        return view('focus.purchaseorders.create-expense', compact('last_tid', 'additionals', 'pricegroups','price_supplier', 'terms', 'prefixes','currency'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreInvoiceRequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(StorePurchaseorderRequest $request)
    {
        // dd($request->all());
        // extract input fields
        $order = $request->only([
            'supplier_type', 'supplier_id', 'suppliername', 'supplier_taxid', 'transxn_ref', 'date', 'validity', 'doc_ref_type', 'doc_ref', 
            'tax', 'note', 'subtotal', 'taxable','tid', 'total','currency_id','currency_rate','lpo_include','document_type','term_id'
        ]);
        //'frx_taxable','frx_total','frx_subtotal',
        $order_items = $request->only([
            'product_id', 'name', 'qty', 'purchase_price', 'tax_rate', 'itemtax', 'item_total', 'type', 'uom','requisition_item_id','item_type' 
        ]);
        if($order['lpo_include'] == 'with_lpo'){
            $date = Carbon::parse($order['date']);
            $due_date = $date->addDays($order['validity']);
            $order['due_date'] = $due_date->toDateString();
        }
        //,'foreign_tax','foreign_taxable','foreign_total','foreign_subtotal','foreign_price'

        $order['ins'] = auth()->user()->ins;
        $order['user_id'] = auth()->user()->id;
        // modify and filter items without item_id
        $order_items = modify_array($order_items);
        if(empty($order_items)){
            return new RedirectResponse(route('biller.purchaseorders.create'), ['flash_error' => 'Line Items Empty']);
        }
        // dd($order_items);
        //$order_items = array_filter($order_items, function ($v) { return $v['product_id']; });

        try {
            $result = $this->repository->create(compact('order', 'order_items'));
        } catch (\Throwable $th) {dd($th);
            return errorHandler('Error creating Purchase Order', $th);
        }

        return new RedirectResponse(route('biller.purchaseorders.index'), ['flash_success' => 'Purchase Order created successfully']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\purchaseorder\Purchaseorder $purchaseorder
     * @param EditPurchaseorderRequestNamespace $request
     * @return \App\Http\Responses\Focus\purchaseorder\EditResponse
     */
    public function edit(Purchaseorder $purchaseorder)
    {
        return new EditResponse($purchaseorder);
    }
    public function edit_expense($purchaseorder)
    {
        //dd($purchaseorder);
        $po = Purchaseorder::find($purchaseorder);
        //$po = $purchaseorder;
        $prefixes = prefixesArray(['purchase_order'], $po->ins);

        $additionals = Additional::all();
        $pricegroups = Pricegroup::all();
        $supplier = Supplier::where('name', 'Walk-in')->first(['id', 'name']);
        $price_supplier = Supplier::whereHas('products')->get(['id', 'name']);
        // Purchase order
        $terms = Term::where('type', 4)->get();
        $currency = Currency::all();

        return view('focus.purchaseorders.edit_expense', compact('po', 'additionals', 'pricegroups','price_supplier', 'terms', 'prefixes','currency'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdatePurchaseorderRequestNamespace $request
     * @param App\Models\purchaseorder\Purchaseorder $purchaseorder
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(StorePurchaseorderRequest $request, Purchaseorder $purchaseorder)
    {
        // extract input fields
        $order = $request->only([
            'supplier_type', 'supplier_id', 'suppliername', 'supplier_taxid', 'transxn_ref', 'date', 'due_date', 'doc_ref_type', 'doc_ref', 
            'tax', 'note', 'subtotal', 'taxable','tid', 'total','currency_id','currency_rate','lpo_include','document_type'
        ]);
        $order_items = $request->only([
            'id','product_id', 'name', 'qty', 'purchase_price', 'tax_rate', 'itemtax', 'item_total', 'type', 'uom','requisition_item_id','item_type'
        ]);

        $order['ins'] = auth()->user()->ins;
        $order['user_id'] = auth()->user()->id;
        // modify and filter items without item_id
        $order_items = modify_array($order_items);
        //$order_items = array_filter($order_items, function ($val) { return $val['product_id']; });

        try {
            $result = $this->repository->update($purchaseorder, compact('order', 'order_items'));
        } catch (\Throwable $th) {dd($th);
            return errorHandler('Error Updating Purchase Order', $th);
        }

        return new RedirectResponse(route('biller.purchaseorders.index'), ['flash_success' => 'Purchase Order updated successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletePurchaseorderRequestNamespace $request
     * @param App\Models\purchaseorder\Purchaseorder $purchaseorder
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(Purchaseorder $purchaseorder)
    {
        try {
            $this->repository->delete($purchaseorder);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting Purchase Order', $th);
        }

        return new RedirectResponse(route('biller.purchaseorders.index'), ['flash_success' => 'Purchase Order deleted successfully']);        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletePurchaseorderRequestNamespace $request
     * @param App\Models\purchaseorder\Purchaseorder $purchaseorder
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show(Purchaseorder $purchaseorder)
    {   
        return new ViewResponse('focus.purchaseorders.view', compact('purchaseorder'));
    }
    public function show_expense($po)
    {   
        $purchaseorder = Purchaseorder::find($po);
        return new ViewResponse('focus.purchaseorders.view_expense', compact('purchaseorder'));
    }

    /**
     * Purchase Order Goods
     */
    public function goods(Request $request)
    {
        $purchaseorder = Purchaseorder::find(request('purchaseorder_id'));
        $stock_goods = $purchaseorder? $purchaseorder->goods()->where('type', 'stock')->get() : collect();
        $stock_goods = $stock_goods->map(function($v) {
            $v->code = '';
            if ($v->unit) {
                $v->code = $v->unit->code;
            }
            elseif ($v->product) {
                $v->code = $v->product->unit ? $v->product->unit->code : '';
            }
            return $v;
        });

        return response()->json($stock_goods);
    }

    public function get_lpo_items()
    {
        $products = [];
        $items = PurchaseRequestItem::where('status_check', '1')->where('purchase_type','purchase_order')->get();

        foreach ($items as $i => $item) {
            $products = array_merge($products, $item);
        }

        $uniqueItems = array_unique($products);
    }

    public function approve(Request $request)
    {
        //dd($request->all());
        $data = $request->only(['approve','approve_note']);
        $data['approved_by'] = auth()->user()->id;
        $purchaseorder = Purchaseorder::find($request->id);
        $purchaseorder->update($data);
        foreach($purchaseorder->items as $i => $item){
            $requisition_item = $item->purchase_request_item;
            if($requisition_item){

                $requisition_item->increment('qty_requested', $item->qty);
            }
            // dd($item);
        }
        return redirect()->back()->with('flash_success','Approved Successfully!!');
    }
    public function search_papers(Request $request)
    {
        $products = [];
        if(request('item_type')== 'paper')
        {

            $items = PurchaseRequestItem::where(['status_check'=>'1','purchase_type'=>'purchase_order','requisition_item_type'=>'paper'])
            ->whereHas('paper', function($q) {
                $q->where('supplier_id', request('supplier_id'))
                ->with(['paper' => fn($q) => $q->where('supplier_id', request('supplier_id'))]);
            })->get();
            //dd($items);
            $grouped_items = $items->groupBy(['item_id']);
            
            foreach ($grouped_items as $item => $val) {
                $total_qty = $val->sum('qty');
                //dd($val->first());
                $products[] = [
                    'name' => @$val->first()->name,
                    'sku' => @$val->first()->sku,
                    'uom' => @$val->first()->uom,
                    'item_id' => @$val->first()->item_id,
                    'purchase_price' => $val->first()->product ? $val->first()->product->purchase_price :'',
                    'qty' => $total_qty,
                ];
            }
        }elseif (request('item_type')=='other_items') {
            $items = PurchaseRequestItem::where(['status_check'=>'1','purchase_type'=>'purchase_order','requisition_item_type'=>'other_items'])->get();
            //dd($items);
            $grouped_items = $items->groupBy(['item_id']);
            
            foreach ($grouped_items as $item => $val) {
                $total_qty = $val->sum('qty');
                //dd($val->first());
                $products[] = [
                    'name' => @$val->first()->name,
                    'sku' => @$val->first()->sku,
                    'uom' => @$val->first()->uom,
                    'item_id' => @$val->first()->item_id,
                    'purchase_price' => $val->first()->product ? $val->first()->product->purchase_price :'',
                    'qty' => $total_qty,
                ];
            }
        }
        return response()->json($products);
    }
}
