<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\question;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\question\QuestionRepository;
use Illuminate\Http\Request;


/**
 * Class questionsTableController.
 */
class QuestionsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var QuestionRepository
     */
    protected $question;

    /**
     * contructor to initialize repository object
     * @param QuestionRepository $question ;
     */
    public function __construct(QuestionRepository $question)
    {
        $this->question = $question;
    }

    /**
     * This method return the data of the model
     * @param Request $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        //
        $core = $this->question->getForDataTable();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('process_name', function ($question) {
                 return $question->process ? $question->process->process_name : '';
            })
            
            ->addColumn('created_at', function ($question) {
                return Carbon::parse($question->created_at)->toDateString();
            })
            ->addColumn('actions', function ($question) {
                return $question->action_buttons;
            })
            ->make(true);
    }
}
