<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\request_quotation;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\request_quotation\RequestQuotationRepository;
use Illuminate\Http\Request;

/**
 * Class request_quotationsTableController.
 */
class RequestQuotationsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var request_quotationRepository
     */
    protected $request_quotation;

    /**
     * contructor to initialize repository object
     * @param RequestQuotationRepository $RequestQuotation ;
     */
    public function __construct(RequestQuotationRepository $request_quotation)
    {
        $this->request_quotation = $request_quotation;
    }

    /**
     * This method return the data of the model
     * @param Managerequest_quotationRequest $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        //
        $core = $this->request_quotation->getForDataTable();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            
            ->editColumn('tid', function ($request_quotation) {
                return gen4tid('RFQ-',$request_quotation->tid);
            })
            ->editColumn('date', function ($request_quotation) {
                return dateFormat($request_quotation->date);
            })
            ->editColumn('due_date', function ($request_quotation) {
                return dateFormat($request_quotation->due_date);
            })
            ->addColumn('actions', function ($request_quotation) {
                return  $request_quotation->action_buttons;
            })
            ->make(true);
    }
}
