<?php

namespace App\Http\Controllers\Focus\shops;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Responses\ViewResponse;
use App\Repositories\Focus\shop\ShopRepository;
use App\Http\Responses\Focus\shop\CreateResponse;
use App\Http\Responses\Focus\shop\EditResponse;
use App\Http\Responses\RedirectResponse;
use App\Models\shops\Shop;

class ShopController extends Controller
{
    protected $repository;
    public function __construct(ShopRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return new ViewResponse('focus.shop.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return new CreateResponse('focus.shop.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['user_id'] = auth()->user()->id;

        try {
            $this->repository->create($input);
        } catch (\Throwable $th) {
            // dd($th);
            return errorHandler('Error creating shop', $th);
        }
        return new RedirectResponse(route('biller.shop.index'), ['flash_success' => 'Shop created successfully']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $shop = Shop::find($id);
        return new ViewResponse('focus.shop.view', compact('shop'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $shop = Shop::find($id);
        return new EditResponse($shop);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $shop = Shop::find($id);

        try {
            $this->repository->update($shop, $input);
        } catch (\Throwable $th) {
            // dd($th);
            return errorHandler('Error updating shop', $th);
        }
        return new RedirectResponse(route('biller.shop.index'), ['flash_success' => 'Shop updated successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $shop = Shop::find($id);

        //Calling the delete method on repository
        try {
            $this->repository->delete($shop);
        } catch (\Throwable $th) {
            return errorHandler('Error deleting shop', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.shop.index'), ['flash_success' => 'Shop deleted successfully']);
    }
}
