<?php

namespace App\Http\Controllers\Focus\stock_adjustment;

use App\Http\Controllers\Controller;
use App\Models\stock_adjustment\StockAdjustment;
use App\Repositories\Focus\stock_adjustment\StockAdjustmentRepository;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class StockAdjustmentTableController extends Controller
{
    protected $stockAdjustment;
    public function __construct(StockAdjustmentRepository $stockAdjustment)
    {
        $this->stockAdjustment = $stockAdjustment;
    }

    public function __invoke(){
        $date = $this->stockAdjustment->getForDataTable();

        return Datatables::of($date)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('tid', function ($stockAdjustment) {
                return 'ST-AD-'.$stockAdjustment->tid;
            })
            ->addColumn('date', function ($stockAdjustment) {
                return dateFormat($stockAdjustment->date);
            })
            // ->addColumn('notes', function ($stockAdjustment) {
            //     return dateFormat($stockAdjustment->date);
            // })
            ->addColumn('status', function ($stockAdjustment) {
                $status = 'NA';
                if($stockAdjustment->status == 0){
                    $status = 'Not Approved';
                }else{
                    $status = 'Approved';
                }
                return $status;
            })

            // ->addColumn('end_date', function ($stockAdjustment) {
            //     return $stockAdjustment->end_date;
            // })
            ->addColumn('actions', function ($stockAdjustment) {
                    return $stockAdjustment->action_buttons;
            })
            ->make(true);
    }
}
