<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

namespace App\Http\Controllers\Focus\transaction;

use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\transaction\TransactionRepository;
use App\Http\Requests\Focus\transaction\ManageTransactionRequest;

/**
 * Class TransactionsTableController.
 */
class TransactionsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var TransactionRepository
     */
    protected $transaction;

    /**
     * Ledger balance
     */
    protected $balance = 0;

    /**
     * contructor to initialize repository object
     * @param TransactionRepository $transaction ;
     */
    public function __construct(TransactionRepository $transaction)
    {
        $this->transaction = $transaction;
    }

    /**
     * This method return the data of the model
     * @param ManageTransactionRequest $request
     *
     * @return mixed
     */
    public function __invoke()
    {
        $query = $this->transaction->getForDataTable();

        $q = clone $query;
        $debit_total = $q->sum('debit');
        $credit_total = $q->sum('credit');

        return Datatables::of($query)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->editColumn('tid', function ($tr) {
                $tid = '';
                if (request('ledger_id')) {
                    if ($tr->debit > 0) {
                        if ($tr->client_invoice) $tid = '<a href="'. route('biller.invoices.show', $tr->invoice) .'">'. gen4tid('Inv-', $tr->invoice->tid) .'</a>';
                        if ($tr->supplier_invoice) $tid = '<a href="'. route('biller.invoices.show', $tr->invoice) .'">'. gen4tid('Bill-', $tr->invoice->tid) .'</a>';
                    } elseif ($tr->credit > 0) {
                        if ($tr->deposit) $tid = '<a href="'. route('biller.invoice_payments.show', $tr->deposit) .'">'. gen4tid('Depo-', $tr->deposit->tid) .'</a>';
                        if ($tr->payment) $tid = '<a href="'. route('biller.invoice_payments.show', $tr->payment) .'">'. gen4tid('Pmt-', $tr->payment->tid) .'</a>';
                    }
                } else {
                    $tid = gen4tid('Ent-', $tr->tid);
                }
                return $tid;             
            })
            ->editColumn('date', function ($tr) {
                return dateFormat($tr->date);
            })
            ->addColumn('type', function ($tr) {
                $type = '';
                if (request('ledger_id')) {
                    if ($tr->debit > 0) {
                        if ($tr->client_invoice) $type = 'Invoice';
                        if ($tr->supplier_invoice) $type = 'Bill';
                    } elseif ($tr->credit > 0) {
                        if ($tr->deposit) $type = 'Deposit';
                        if ($tr->payment) $type = 'Payment';
                    }
                } else {
                    $type = @$tr->account->ledger_type;
                }
                return $type;  
            })
            ->editColumn('ledger_id', function ($tr) {                
                return @$tr->account->name;
            })
            ->editColumn('debit', function ($tr) {                
                return numberFormat($tr->debit);
            })
            ->editColumn('credit', function ($tr) {
                return numberFormat($tr->credit);
            })
            ->addColumn('balance', function ($tr) use($debit_total, $credit_total) {
                $balance = 0;
                if (request('ledger_id')) {
                    if (in_array(@$tr->account->ledger_type, ['asset', 'expense'])) {
                        $balance = $debit_total - $credit_total;
                    } else {
                        $balance = $credit_total - $debit_total;
                    }
                } else {
                    $balance = $tr->group_balance;
                }
                return numberFormat($balance);
            })
            ->addColumn('client_supplier', function ($tr) {
                $company = '';
                if ($tr->customer) $company = $tr->customer->company;
                if ($tr->supplier) $company = $tr->supplier->company;
                return $company;
            })
            ->addColumn('actions', function ($tr) {
                return $tr->action_buttons;
            })
            ->make(true);
    } 
}