<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

namespace App\Http\Controllers\Focus\warehouse;

use App\Models\warehouse\Warehouse;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\warehouse\CreateResponse;
use App\Http\Responses\Focus\warehouse\EditResponse;
use App\Repositories\Focus\warehouse\WarehouseRepository;
use App\Http\Requests\Focus\warehouse\ManageWarehouseRequest;
use App\Http\Requests\Focus\warehouse\StoreWarehouseRequest;
use App\Models\product\ProductVariation;
use DB;

/**
 * WarehousesController
 */
class WarehousesController extends Controller
{
    /**
     * variable to store the repository object
     * @var WarehouseRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param WarehouseRepository $repository ;
     */
    public function __construct(WarehouseRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\warehouse\ManageWarehouseRequest $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(ManageWarehouseRequest $request)
    {
        $product_count = ProductVariation::count();
        $product_worth = ProductVariation::sum(DB::raw('qty*purchase_price'));

        return new ViewResponse('focus.warehouses.index', compact('product_count', 'product_worth'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param CreateWarehouseRequestNamespace $request
     * @return \App\Http\Responses\Focus\warehouse\CreateResponse
     */
    public function create(StoreWarehouseRequest $request)
    {
        return new CreateResponse('focus.warehouses.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreWarehouseRequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(StoreWarehouseRequest $request)
    {
        //Input received from the request
        $input = $request->except(['_token', 'ins']);
        $input['ins'] = auth()->user()->ins;
        //Create the model using repository create method
        try {
            $this->repository->create($input);
        } catch (\Throwable $th) {
            return errorHandler('Error Creating Product Location', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.warehouses.index'), ['flash_success' => 'Product Location Created Successfully']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\warehouse\Warehouse $warehouse
     * @param EditWarehouseRequestNamespace $request
     * @return \App\Http\Responses\Focus\warehouse\EditResponse
     */
    public function edit(Warehouse $warehouse, StoreWarehouseRequest $request)
    {
        return new EditResponse($warehouse);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateWarehouseRequestNamespace $request
     * @param App\Models\warehouse\Warehouse $warehouse
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(StoreWarehouseRequest $request, Warehouse $warehouse)
    {
        //Input received from the request
        $input = $request->except(['_token', 'ins']);
        //Update the model using repository update method
        try {
            $this->repository->update($warehouse, $input);
        } catch (\Throwable $th) {
            return errorHandler('Error Updating Product Location', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.warehouses.index'), ['flash_success' => 'Product Location Updated Successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeleteWarehouseRequestNamespace $request
     * @param App\Models\warehouse\Warehouse $warehouse
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(Warehouse $warehouse, StoreWarehouseRequest $request)
    {
        //Calling the delete method on repository
        try {
            $this->repository->delete($warehouse);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting Product Location', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.warehouses.index'), ['flash_success' => 'Product Location Deleted Successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeleteWarehouseRequestNamespace $request
     * @param App\Models\warehouse\Warehouse $warehouse
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show(Warehouse $warehouse, ManageWarehouseRequest $request)
    {

        //returning with successfull message
        return new ViewResponse('focus.warehouses.view', compact('warehouse'));
    }

    // warehouse products
    public function warehouse_products()
    {
        $products = ProductVariation::where('warehouse_id', request('warehouse_id'))
            ->where('qty', '>=', 1)
            ->get()
            ->map(function($v) {
                $v->unit = '';
                if ($v->product && $v->product->unit) {
                    $v->unit =  $v->product->unit->code;
                }
                return $v;
            });

        return $products->toArray();
    }

    public function select(ManageWarehouseRequest $request){
        $q = $request->keyword;
        $warehouses = Warehouse::where('title', 'LIKE', '%'.$q.'%')
            // ->where('active', 1)->orWhere('email', 'LIKE', '%'.$q.'')
            ->limit(6)->get(['id', 'title']);

        return response()->json($warehouses);
    }

}
