<?php

namespace App\Http\Controllers\Focus\warehouse_row;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Requests\Focus\warehouse_row\StoreWareHouseRowRequest;
use App\Http\Requests\Focus\warehouse_row\UpdateWareHouseRequest;
use App\Repositories\Focus\warehouse_row\WareHouseRowRepository;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\warehouse_row\CreateResponse;
use App\Models\warehouse_row\WareHouseRow;
use App\Http\Requests\Focus\warehouse_row\ManageWareHouseRowRequest;
use App\Http\Responses\Focus\warehouse_row\EditResponse;
use App\Models\warehouse\Warehouse;

class WareHouseRowController extends Controller
{
    protected $repository;

    public function __construct(WareHouseRowRepository $repository)
    {
        $this->repository = $repository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ManageWareHouseRowRequest $request)
    {
        $warehouse_id = $request->query('warehouse');
        $warehouse = Warehouse::where('id', $warehouse_id)->withCount('warehouse_rows')->first();

        if($warehouse == null){
            return redirect()->route('biller.warehouses.index');
        }

        return new ViewResponse('focus.warehouses.warehouse_rows.index', compact('warehouse','warehouse_id'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return new CreateResponse('focus.warehouses.warehouse_rows.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreWareHouseRowRequest $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        // dd($input['ins']);
        try{
            $this->repository->create($input);
        }catch(\Throwable $th){
            return errorHandler('Error Creating Warehouse Row', $th);
        }

        return new RedirectResponse(route('biller.warehouse-rows.index'), ['flash_success' => 'Warehouse Row created successfully']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, ManageWareHouseRowRequest $request)
    {
        $warehouse_row = WareHouseRow::where('id', $id)->first();
        return new ViewResponse('focus.warehouses.warehouse_rows.view', compact('warehouse_row'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $warehouse_row = WareHouseRow::where('id', $id)->first();
        return new EditResponse($warehouse_row);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateWareHouseRequest $request, $id)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        // dd($input['ins']);
        try{
            $this->repository->update($input, $id);
        }catch(\Throwable $th){
            return errorHandler('Error Updating Warehouse Row', $th);
        }

        return new RedirectResponse(route('biller.warehouse-rows.index'), ['flash_success' => 'Warehouse Row was updated successfully']);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(UpdateWareHouseRequest $request, $id)
    {
        try {
            $this->repository->delete($id);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting Warehouse Row', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.warehouse-rows.index'), ['flash_success' => 'Warehouse Row was deleted successfully']);
    }
}
