<?php

namespace App\Http\Controllers\Focus\warehouse_row;

use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Http\Request;
use App\Repositories\Focus\warehouse_row\WareHouseRowRepository;

class WareHouseRowTableController extends Controller
{
    protected $warehouse_row;
    public function __construct(WarehouseRowRepository $warehouse_row, Request $request)
    {
        $this->warehouse_row = $warehouse_row;
    }

    public function __invoke($id){
        $core = $this->warehouse_row->getForDataTable($id);

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('row_number', function ($warehouse_row) {
                return '<a class="font-weight-bold" href="' . route('biller.products.index') . '?rel_type=2&rel_id=' . $warehouse_row->id . '">' . $warehouse_row->row_number . '</a>';
            })
            ->addColumn('number_of_shelves', function ($warehouse_row) {
                return '<a class="font-weight-bold" href="' . route('biller.warehouse-shelf.index') . '?warehouse=' . $warehouse_row->ware_house_id . '&warehouse_row=' .$warehouse_row->id.' ">' . count($warehouse_row->wareHouseShelf). '</a>';
            })
            ->addColumn('created_at', function ($warehouse_row) {
                return dateFormat($warehouse_row->created_at);
            })
            ->addColumn('actions', function ($warehouse_row) {
                    return $warehouse_row->action_buttons;
            })
            ->make(true);
    }
}
