<?php

namespace App\Http\Controllers\Focus\warehouse_shelves;

use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Http\Request;
use App\Repositories\Focus\warehouse_shelf\WareHouseShelfRepository;

class WareHouseShelfTableController extends Controller
{
    protected $warehouse_shelf;
    public function __construct(WareHouseShelfRepository $warehouse_shelf)
    {
        $this->warehouse_shelf = $warehouse_shelf;
    }

    public function __invoke(){
        $core = $this->warehouse_shelf->getForDataTable();

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('shelf_number', function ($warehouse_shelf) {
                return '<a class="font-weight-bold" href="' . route('biller.products.index') . '?rel_type=2&r el_id=' . $warehouse_shelf->id . '">' . $warehouse_shelf->shelf_number . '</a>';
            })
            ->addColumn('size', function ($warehouse_shelf) {
                return $warehouse_shelf->length.'x'.$warehouse_shelf->width.'x'.$warehouse_shelf->height;
            })
            // ->addColumn('total', function ($warehouse_row) {
            //     return  1;
            // })
            // ->addColumn('worth', function ($warehouse_row) {
            //     $worth = 0;
            //     foreach ($warehouse->products as $product) {
            //         $worth += $product->purchase_price * $product->qty;
            //     }
            //     return numberFormat($worth);
            // })
            ->addColumn('created_at', function ($warehouse_shelf) {
                return dateFormat($warehouse_shelf->created_at);
            })
            ->addColumn('actions', function ($warehouse_shelf) {
                // return '<a class="btn btn-purple round" href="'. route('biller.products.index', ['warehouse_row' => $warehouse_row->id]) .'" title="products"><i class="fa fa-list"></i></a>'
                //     . $warehouse_row->action_buttons;
                    return $warehouse_shelf->action_buttons;
            })
            ->make(true);
    }
}
