<?php

namespace App\Http\Controllers\Focus\warehouse_shelves;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Responses\RedirectResponse;
use App\Repositories\Focus\warehouse_shelf\WareHouseShelfRepository;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\warehouse_shelf\CreateResponse;
use App\Models\warehouse_row\WareHouseRow;
use App\Models\warehouse\Warehouse;
use App\Http\Requests\Focus\warehouse_shelf\StoreWareHouseShelfRequest;
use App\Models\warehouse_shelves\WarehouseShelf;
use App\Http\Responses\Focus\warehouse_shelf\EditResponse;
use App\Http\Requests\Focus\warehouse_shelf\UpdateWareHouseShelfRequest;


class WarehouseShelfController extends Controller
{
    protected $repository;

    public function __construct(WareHouseShelfRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $warehouse_id = $request->query('warehouse');
        $warehouse_row_id = $request->query('warehouse_row');
        $warehouse_shelves = WarehouseShelf::where('warehouse_id', $warehouse_id)->where('warehouse_row_id', $warehouse_row_id)->first();

        $warehouse = Warehouse::where('id', $warehouse_id)->first();
        $warehouseRow = WarehouseRow::where('id', $warehouse_row_id)->first();

        if($warehouse == null){
            return redirect()->route('biller.warehouses.index');
        }

        if($warehouseRow == null){
            return redirect()->route('biller.warehouses.index');
        }

        return new ViewResponse('focus.warehouses.warehouse_rows.warehouse_shelves.index', compact('warehouse', 'warehouseRow'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return new CreateResponse('focus.warehouses.warehouse_rows.warehouse_shelves.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreWareHouseShelfRequest $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;

        $warehouseShelf = WarehouseShelf::create([
            'warehouse_id' => $input['warehouse_id'],
            'warehouse_row_id' => $input['warehouse_row_id'],
            'shelf_number' => $input['shelf_number'],
            'extra' => $input['extra'],
            'length' => $input['length'],
            'width' => $input['width'],
            'height' => $input['height'],
            'ins' => $input['ins'],
        ]);


        // try{
        //     $this->repository->create($input);
        // }catch(\Throwable $th){
        //     return errorHandler('Error Creating Warehouse Shelf', $th);
        // }

        return new RedirectResponse(route('biller.warehouse-shelf.index'), ['flash_success' => 'Warehouse Shelf created successfully']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $warehouseShelf = WarehouseShelf::where('id', $id)->first();
        return new ViewResponse('focus.warehouses.warehouse_rows.warehouse_shelves.view', compact('warehouseShelf'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $warehouseShelf = WarehouseShelf::where('id', $id)->first();
        return new EditResponse($warehouseShelf);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateWareHouseShelfRequest $request, $id)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        // dd($input['ins']);
        try{
            $this->repository->update($input, $id);
        }catch(\Throwable $th){
            return errorHandler('Error Updating Warehouse Shelf', $th);
        }

        return new RedirectResponse(route('biller.warehouse-shelf.index'), ['flash_success' => 'Warehouse Shelf was updated successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(UpdateWareHouseShelfRequest $request, $id)
    {
        try {
            $this->repository->delete($id);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting Warehouse Shelf', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.warehouse-shelf.index'), ['flash_success' => 'Warehouse Shelf was deleted successfully']);
    }

    public function getWarehouseRows(Request $request){
        $warehouse_id = $request->warehouse_id;
        $warehouse_rows = WareHouseRow::where('ware_house_id', $warehouse_id)->where('ins', auth()->user()->ins)->get(['id', 'row_number']);
        return response()->json($warehouse_rows);
    }

    public function getWarehouseRowShelves(Request $request){
        $warehouse_id = $request->warehouse_id;
        $warehouse_row_id = $request->warehouse_row_id;

        $warehouse_shelves = WarehouseShelf::where('warehouse_id', $warehouse_id)->where('warehouse_row_id', $warehouse_row_id)->where('ins', auth()->user()->ins)->get(['id', 'shelf_number']);
        return response()->json($warehouse_shelves);

    }
}
