<?php

namespace App\Http\Controllers\Focus\waste_management;

use App\Http\Controllers\Controller;
use App\Http\Requests\Focus\waste_management\CreateWasteManagementRequest;
use App\Http\Requests\Focus\waste_management\ManageWasteManagementRequest;
use App\Http\Requests\Focus\waste_management\StoreWasteManagementRequest;
use App\Repositories\Focus\waste_management\WasteManagementRepository;
use Illuminate\Http\Request;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\Focus\waste_management\CreateResponse;
use App\Http\Responses\Focus\waste_management\EditResponse;
use App\Models\assembly\assembly_station\AssemblyStation;
use App\Models\product\Product;
use App\Models\waste_management\WasteManagement;
use DB;

class WasteManagementController extends Controller
{
    protected $repository;

    public function __construct(WasteManagementRepository $repository)
    {
        $this->repository = $repository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ManageWasteManagementRequest $request)
    {
        return new ViewResponse('focus.waste_management.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(CreateWasteManagementRequest $request)
    {
        return new CreateResponse('focus.waste_management.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $data = $request->only(['tid', 'date','description']);
        $data['ins'] = auth()->user()->ins;
        $data['user_id'] = auth()->user()->id;

        $data_items = $request->only(['name','uom','qty','item_id']);
        $data_items = modify_array($data_items);

        try {
            $this->repository->create(compact('data','data_items'));
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler('Error adding waste products.', $th);
        }

        return new RedirectResponse(route('biller.waste-management.index'), ['flash_success' => 'Waste products added successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(WasteManagement $waste_management)
    {
        return new ViewResponse('focus.waste_management.view', compact('waste_management'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(WasteManagement $waste_management)
    {
        return new EditResponse($waste_management);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, WasteManagement $waste_management)
    {
        $data = $request->only(['date','description']);
        $data['ins'] = auth()->user()->ins;
        $data['user_id'] = auth()->user()->id;

        $data_items = $request->only(['name','uom','qty','item_id', 'id']);
        $data_items = modify_array($data_items);


        try {
            $this->repository->update($waste_management, compact('data', 'data_items'));
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler($th, 'Error updating waste products');
        }

        return new RedirectResponse(route('biller.waste-management.index'), ['flash_success' => 'Waste products updated successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $waste_management = WasteManagement::where('id',$id)->with('waste_management_items')->first();
        try {
            $this->repository->delete($waste_management);
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler($th, 'Error deleting waste products');
        }

        return new RedirectResponse(route('biller.waste-management.index'), ['flash_success' => 'Waste products deleted successfully.']);
    }

    public function getReportView(){
        $products = Product::all();
        $stations = AssemblyStation::all();
        return view('focus.waste_management.waste_management_report', compact('products','stations'));
    }

    public function approve(Request $request)
    {
        // dd($request->all());
        DB::beginTransaction();
        $waste_management = WasteManagement::find($request->id);
        $waste_management->status = $request->status;
        $waste_management->approve_note = $request->approve_note;
        if($request->status == 'approved'){
            $waste_management->approved_by = auth()->user()->id;
            foreach ($waste_management->items as $item) {
                $product = Product::find($item->item_id);
                $product->qty = $product->qty + $item->qty;
                $product->update();
                // dd($item->item_id);
            }
        }
        $result = $waste_management->update();
        if ($result) {
            DB::commit();
            return back()->with('flash_success', 'Waste Received Successfully!!');      
        }
        return back()->with('flash_error', 'Error Receiving waste!!');
    }
}
