<?php

namespace App\Http\Controllers\Focus\waste_management;

use App\Http\Controllers\Controller;
use App\Repositories\Focus\waste_management\WasteManagementReportRepository;
use Yajra\DataTables\Facades\DataTables;

class WasteManagementReportController extends Controller
{
    protected $waste_management_items;

    public function __construct(WasteManagementReportRepository $waste_management_items)
    {
        $this->waste_management_items = $waste_management_items;
    }


    public function __invoke()
    {
        $core = $this->waste_management_items->getForDataTable();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('product', function ($waste_management) {
                return  $waste_management->product->name;
            })
            ->addColumn('initial_qty', function ($waste_management) {
                return $waste_management->current_quantity;
            })
            ->addColumn('waste_qty', function ($waste_management) {
                return $waste_management->waste_quantity;
            })
            ->addColumn('final_qty', function ($waste_management) {
                return $waste_management->final_quantity;
            })
            ->addColumn('uom', function ($waste_management) {
                return  $waste_management->unit_of_measure->title;
            })
            ->addColumn('station', function ($waste_management) {
                return $waste_management->station->name;
            })
            ->addColumn('added_by', function ($waste_management) {
                return $waste_management->user->first_name.' '.$waste_management->user->last_name;
            })
            ->addColumn('date', function ($waste_management) {
                return $waste_management->created_at->toDateString();
            })
            ->make(true);
    }
}
