<?php

namespace App\Http\Controllers\Focus\waste_management;

use App\Http\Controllers\Controller;
use App\Repositories\Focus\waste_management\WasteManagementRepository;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use DB;

class WasteManagementTableController extends Controller
{
    protected $waste_management;

    public function __construct(WasteManagementRepository $waste_management)
    {
        $this->waste_management = $waste_management;
    }


    public function __invoke()
    {
        $core = $this->waste_management->getForDataTable();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('entry_no', function ($waste_management) {
                return  $waste_management->tid;
            })
            ->addColumn('date', function ($waste_management) {
                return dateFormat($waste_management->date);
            })
            ->addColumn('description', function ($waste_management) {
                return  $waste_management->description;
            })
            ->addColumn('status', function ($waste_management) {
                return  ucfirst($waste_management->status);
            })
            ->addColumn('added_by', function ($waste_management) {
                return @$waste_management->user->first_name.' '.@$waste_management->user->last_name;
            })
            ->addColumn('actions', function ($waste_management) {
                return $waste_management->action_buttons;
            })
            ->make(true);
    }
}
