<?php

namespace App\Http\Controllers\Focus\work_order;

use App\Http\Controllers\Controller;
use App\Repositories\Focus\work_order\WorkOrderRepository;
use Yajra\DataTables\Facades\DataTables;

class ApprovedWorkOrderTableController extends Controller
{
    protected $repository;

    public function __construct(WorkOrderRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke()
    {
        $query = $this->repository->getForDataTable();
        $query->where('status', 'approved')->doesntHave('invoice');

        return Datatables::of($query)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->editColumn('tid', function ($order) {
                return '<a href="'. route('biller.work_orders.show', $order) .'">'. $order->tid_code .'</a>';
            })
            ->editColumn('customer_id', function ($order) {
                return  @$order->customer->company ?: @$order->customer->name;
            })
            ->editColumn('date', function ($order) {
                return  dateFormat($order->date);
            })
            ->editColumn('due_date', function ($order) {
                return  dateFormat($order->due_date);
            })
            ->editColumn('total', function ($order) {
                return  numberFormat($order->total);
            })
            ->editColumn('status', function ($order) {
                $badge_type = $order->status == 'approved'? 'badge-primary' : 'badge-warning';
                return '<span data-id="'. $order->id .'" class="badge '. $badge_type .'">'. $order->status .'</span>';
            })
            ->addColumn('inv_status', function ($order) {
                if ($order->invoice) return '<a href="'. route('biller.invoices.show', $order->invoice) .'">'. $order->invoice->tid_code .'</a>';
                return '<span data-id="'. $order->id .'" invoice-url="'. route('biller.invoices.raise_invoice', ['work_order_id' => $order->id, '_token' => csrf_token()]) .'" data-status="'. $order->status .'" class="badge badge-secondary inv_status" style="cursor:pointer;">
                raise invoice <i class="fa fa-caret-down" aria-hidden="true"></i></span>';
            })
            ->addColumn('actions', function ($order) {
                return $order->action_buttons;
            })
            ->make(true);
    }
}
