<?php

namespace App\Http\Controllers\Focus\work_order;

use App\Http\Controllers\Controller;
use App\Models\invoice\Invoice;
use App\Models\items\InvoiceItem;
use Illuminate\Http\Request;
use App\Models\work_order\WorkOrder;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use Carbon\Carbon;
use DB;

class InvoiceController extends Controller
{
    public function index(){
        return new ViewResponse('focus.work_orders.invoices.index');
    }
    public function workOrderToInvoice($id){
        $pi = WorkOrder::find($id);
        return view('focus.work_orders.invoices.view', compact('pi'));
    }

    public function generateInvoice(Request $request, $id){
        $workOrder = WorkOrder::find($id);
        // dd($workOrder);
        $count = DB::table('invoices')->count();

        $tid = Invoice::max('tid') + 1;
        $reference_number = 'INV'. $tid;

        // dd($workOrder->work_order_items);

        $data=[
            'tid' => $count,
            'reference_number' => $reference_number,
            'title' => $reference_number,
            'is_standard' => 0,
            'work_order_id' => $workOrder->id,
            // 'currency_id' => $workOrder->currency,
            'currency_id' => 1,
            'currency_rate' => $workOrder->currency_rate,
            'invoicedate' => Carbon::now(),
            'invoiceduedate' => Carbon::now(),
            'taxable' => $workOrder->taxable,
            'sub_total' => $workOrder->sub_total,
            'tax' => $workOrder->tax,
            'total' => $workOrder->total,
            'frx_subtotal' => $workOrder->frx_sub_total,
            'frx_total' => $workOrder->frx_total,
            'frx_tax' => $workOrder->frx_tax,
            'frx_taxable' => $workOrder->frx_taxable,
            'notes' => $workOrder->notes,
            'status' => 0,
            'customer_id' => $workOrder->customer_id,
            // 'tax_id'=> $request->tax_id,
            'tax_id'=> $workOrder->tax_id,
            'term_id'=> $workOrder->term_id,
            'bank_id'=> $workOrder->bank_id,
            'validity'=> $workOrder->validity,
            'amountpaid'=> 0,
            'account_id'=> $workOrder->income_account,
            // 'claimer_tax_pin'=> $request->claimer_tax_pin,
            // 'claimer_company'=> $request->claimer_company,
            // 'product_expense_total' => 1,
            'user_id' => auth()->user()->id,
            'ins' => auth()->user()->id,
        ];

        $invoice = Invoice::create($data);

        foreach($workOrder->work_order_items as $k => $v){

            $itemData =[
                'invoice_id' => $invoice->id,
                'numbering' => 0,
                'row_index' => 0,
                'description' => null,
                'quantity' => $v->quantity,
                'unit_cost' =>0,
                'total_cost' => $v->unit_cost,
                'tax_id' => $v->tax_id,
                'tax'=> $v->tax,
                'amount' =>$v->amount,
                'unit_id' => $v->uom,
                'unit_value' => $v->uom,
                'project_id' => 0,
                'quote_id' => 0,
                'product_id' => $v->product_id
            ];
            InvoiceItem::insert($itemData);
        }

        return new RedirectResponse(route('biller.wo-invoices.index'), ['flash_success' => 'Invoice created successfully.']);
    }
}




