<?php

namespace App\Http\Controllers\Focus\work_order;

use App\Http\Controllers\Controller;
use App\Models\invoice\Invoice;
use App\Repositories\Focus\invoice\InvoiceRepository;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;


class InvoiceTableController extends Controller
{
    const MODEL = Invoice::class;

    protected $invoice;

    public function __construct(InvoiceRepository $invoice)
    {
        $this->invoice = $invoice;
    }

    public function __invoke()
    {
        $core = $this->invoice->getForDataTable();

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('invoice_no', function ($invoice) {
                return $invoice->title;
            })
            // ->addColumn('title', function ($workOrder) {
            //     return  $workOrder->title;
            // })
            ->addColumn('customer', function ($invoice) {
                return  $invoice->customer ? $invoice->customer->name : '--';
            })
            ->addColumn('amount', function ($invoice) {
                return  $invoice->total;
            })
            ->addColumn('status', function ($invoice) {
                return  $invoice->status;
            })
            // ->addColumn('invoice_no', function ($workOrder) {
            //     return numberFormat( $workOrder->status);
            // })
            ->addColumn('actions', function ($invoice) {
                return $invoice->action_buttons;
            })
            ->make(true);
    }
}
