<?php

namespace App\Http\Controllers\Focus\work_order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use DB;

class PITableController extends Controller
{
    public function __invoke()
    {
        $pi = DB::table('pi_work_order')->get();

        return Datatables::of($pi)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('pi_no', function ($pi) {
                return $pi->tid;
            })
            ->addColumn('title', function ($pi) {
                return  $pi->title;
            })
            ->addColumn('customer', function ($pi) {
                return  $pi->work_order_id;
            })
            // ->addColumn('amount', function ($pi) {
            //     return  $pi->grand_total;
            // })
            ->addColumn('status', function ($pi) {
                return  $pi->status;
            })
            ->addColumn('invoice_no', function ($pi) {
                return numberFormat( $pi->status);
            })
            ->addColumn('actions', function ($pi) {
                return
                '<a href="' . route('biller.pi.view', $pi->id ) . '" class="btn btn-warning round" data-toggle="tooltip" data-placement="top" title="Edit"><i  class="fa fa-eye "></i></a>'.' '.
                '<a href="' . route('biller.pi.print', $pi->id ) . '" class="btn btn-purple round" data-toggle="tooltip" data-placement="top" title="Edit"><i  class="fa fa-print "></i></a>';
                // return $pi->action_buttons;
            })
            ->make(true);
    }
}
