<?php

namespace App\Http\Controllers\Focus\work_order;

use App\Http\Controllers\Controller;
use App\Repositories\Focus\work_order\WorkOrderRepository;
use Yajra\DataTables\Facades\DataTables;

class WorkOrderTableController extends Controller
{
    protected $repository;

    public function __construct(WorkOrderRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke()
    {
        $query = $this->repository->getForDataTable();

        return Datatables::of($query)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->editColumn('tid', function ($order) {
                return '<a href="'. route('biller.work_orders.show', $order) .'">'. $order->tid_code .'</a>';
            })
            ->editColumn('customer_id', function ($order) {
                return  @$order->customer->company ?:  @$order->customer->name;
            })
            ->editColumn('date', function ($order) {
                return  dateFormat($order->date);
            })
            ->editColumn('due_date', function ($order) {
                return  dateFormat($order->due_date);
            })
            ->editColumn('total', function ($order) {
                return  numberFormat($order->total);
            })
            ->editColumn('status', function ($order) {
                $badge_type = $order->status == 'approved'? 'badge-primary' : 'badge-warning';
                return '<span data-id="'. $order->id .'" class="badge '. $badge_type .'">'. $order->status .'</span>';
            })
            ->addColumn('inv_status', function ($order) {
                if (!$order->invoice) return;
                return '<a href="'. route('biller.invoices.show', $order->invoice) .'">'. $order->invoice->tid_code .'</a>';
            })
            ->addColumn('actions', function ($order) {
                return $order->action_buttons;
            })
            ->make(true);
    }
}
