<?php

namespace App\Http\Requests\Focus\warehouse_shelf;

use Illuminate\Foundation\Http\FormRequest;

class StoreWareHouseShelfRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'warehouse_id'=>'required|integer',
            'warehouse_row_id' => 'required|integer',
            'shelf_number'=>'required',
        ];
    }
    public function messages()
    {
        return [
            'warehouse_id.required' => 'The warehouse is required.',
            'warehouse_row_id.required' => 'The warehouse row number is required.',
            'shelf_number.required' => 'The shelf number is required.',
        ];
    }
}
