<?php

namespace App\Http\Responses\Focus\assembly\assembly_stations;

use Illuminate\Contracts\Support\Responsable;
use DB;

class EditResponse implements Responsable
{
    protected $assembly_station;

    /**
     * @param App\Models\product\Product $product
     */
    public function __construct($assembly_station)
    {
        $this->assembly_station = $assembly_station;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        return view('focus.assembly.assembly_station.edit')->with(['assembly_station' => $this->assembly_station]);
    }
}
