<?php

namespace App\Http\Responses\Focus\assembly\material_issuing;

use Illuminate\Contracts\Support\Responsable;
use App\Models\productcategory\Productcategory;
use App\Models\productvariable\Productvariable;
use App\Models\warehouse\Warehouse;
use App\Models\product\Product;
use App\Models\assembly\assembly_station\AssemblyStation;

class EditResponse implements Responsable
{
    protected $material_issuing;

    public function __construct($material_issuing)
    {
        $this->material_issuing = $material_issuing;
    }

    public function toResponse($request)
    {
        $product_categories = Productcategory::all();
        $warehouses = Warehouse::all();
        $productvariables = Productvariable::all();
        $products = Product::all();
        $assembly_stations = AssemblyStation::all();
        return view('focus.assembly.material_issuing.edit',compact('product_categories', 'assembly_stations','productvariables','products', 'warehouses'))->with(['material_issuing' => $this->material_issuing]);
    }
}
