<?php

namespace App\Http\Responses\Focus\bom;

use App\Models\product\Product;
use App\Models\car_model\CarModel;
use App\Models\productvariable\Productvariable;
use App\Models\shops\Shop;
use Illuminate\Contracts\Support\Responsable;
use App\Models\jobcard\JobCard;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $products = Product::all();
        $shops = Shop::all();
        $car_models = CarModel::all();
        $productvariables = Productvariable::all();
        $jobcards = JobCard::where('status','approved')->where('bom_id','<',1)->get();
        return view('focus.bom.create', compact('products', 'shops', 'car_models','productvariables','jobcards'));
    }
}
