<?php

namespace App\Http\Responses\Focus\charge;

use App\Models\account\Account;
use Illuminate\Contracts\Support\Responsable;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $bank_accounts = Account::whereHas('account_type', fn($q) => $q->where('code', 'bank'))->get();
        $expense_accounts = Account::where('ledger_type', 'expense')->get();

        return view('focus.charges.create', compact('bank_accounts', 'expense_accounts'));
    }
}
