<?php

namespace App\Http\Responses\Focus\jobcard;

use Illuminate\Contracts\Support\Responsable;
use App\Models\customer\Customer;
use App\Models\process\Process;
use Carbon\Carbon;
use App\Models\jobcard\JobCard;
use App\Models\print_design\PrintDesign;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $customers = Customer::all(['id', 'company']);
        $processes = Process::all(['id', 'process_name']);
        $currentDate = Carbon::now()->format('Ym');
        $current_month = substr($currentDate, 4);
        $current_year = substr($currentDate, 0, 4);
        $start_month = Carbon::now()->startOfMonth();
        $end_month = Carbon::now()->endOfMonth();
        $count = JobCard::whereBetween('created_at',[$start_month, $end_month])->count();
        $count += 1;
        $jobcard_number = gen4tid('',$count).''.$current_month.''.$current_year;
        $designs = PrintDesign::where('status','active')->get(['id','description']);
        // dd();
        return view('focus.jobcards.create', compact('customers','processes','jobcard_number','designs'));
    }
}