<?php

namespace App\Http\Responses\Focus\paper;

use Illuminate\Contracts\Support\Responsable;
use App\Models\gsm\GSM;
use App\Models\supplier\Supplier;
use App\Models\paper_width\PaperWidth;
use App\Models\productvariable\Productvariable;
use App\Models\paper\PaperName;
use App\Models\account\Account;

class EditResponse implements Responsable
{
    /**
     * @var App\Models\paper\paper
     */
    protected $papers;

    /**
     * @param App\Models\paper\paper $papers
     */
    public function __construct($papers)
    {
        $this->papers = $papers;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        // $paper_width = PaperWidth::all(['id', 'name']);
        $productvariables = Productvariable::all();
        // $gsm = GSM::all(['id', 'name','quality']);
        $paper_width = PaperName::where('type', '1')->get(['id','name']);
        $gsm = PaperName::where('type', '2')->get(['id','name']);
        $suppliers = Supplier::get();
        $account = Account::where('system', 'stock')->first();
        return view('focus.papers.edit')->with([
            'papers' => $this->papers,
            'gsm' => $gsm,
            'paper_width' => $paper_width,
            'productvariables' => $productvariables,
            'suppliers' => $suppliers,
            'account' => $account
        ]);
    }
}