<?php

namespace App\Http\Responses\Focus\product;

use App\Models\productcategory\Productcategory;
use App\Models\productvariable\Productvariable;
use App\Models\warehouse\Warehouse;
use Illuminate\Contracts\Support\Responsable;
use App\Models\supplier\Supplier;
use App\Models\account\Account;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $product_categories = Productcategory::all();
        $warehouses = Warehouse::all();
        $productvariables = Productvariable::all();
        $suppliers = Supplier::get(['id', 'name','email']);
        $account = Account::where('system', 'stock')->first(); 
        
        return view('focus.products.create')->with(compact('product_categories','account', 'productvariables', 'warehouses','suppliers'));
    }
}